#!/usr/bin/perl
#
# -n num  -- number of nodes in the topology

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_e);

getopts("n:e:");
defined $opt_n or die "number of nodes?";

our $EMULAB = defined $opt_e ? $opt_e : "utah";
our $NODES = $opt_n;
our $PCTYPE = ($EMULAB eq "utah" ? "pc850" : "i2");

my $date = `date`;

print <<EOT;
set ns [new Simulator]		
source tb_compat.tcl

# Nodes
set maxnodes $NODES
set lanstr ""

for {set i 0} {\$i < \$maxnodes} {incr i} {
    set nodeName node\$i

	set \$nodeName [\$ns node]
	append lanstr "\$nodeName "

	tb-set-node-rpms \$nodeName /proj/DNA/jeffpang/bittorrent-3.4.2-1.0.noarch.rpm /proj/DNA/jeffpang/screen-4.0.2-5.i386.rpm /proj/DNA/jeffpang/valgrind-2.2.0-7.i386.rpm /proj/DNA/jeffpang/google-perftools-0.1-1.rh9.i386.rpm
	tb-set-hardware \$nodeName $PCTYPE
}

set lan0 [\$ns make-lan "\$lanstr" 100Mb 0ms]

\$ns rtproto Static

# Set the commands to run 
for { set i 0 } { \$i < \$maxnodes } { incr i } {
    set nodeName node\$i
	tb-set-node-startcmd \$nodeName "/usr/bin/sudo rpm --force -Uvh /proj/DNA/jeffpang/*.rpm"
}

\$ns run

# End of generated file. Generate at $date
EOT


    
