#!/usr/bin/perl
#
# Run a series of experiment trials on emulab
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C $opt_k $opt_o $opt_y);
use lib "./emulab";
use Travertine;
use EmulabConf;

getopts("n:t:E:v:b:NCko:y:");

our $APPCONF       = "TestgameConf.pl";

# defaults
our $MODE          = "";
our $EXP_NAME      = defined $opt_E ? $opt_E : "lan-30";
our $MAX_NODES     = defined $opt_n ? $opt_n : 30;
# virtual time (exp time *= slowdown)
our $TIME_LIM      = defined $opt_t ? $opt_t : 8*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 5;
our $BOTS          = defined $opt_b ? $opt_b : 8;
our $SLOWDOWN      = defined $opt_y ? $opt_y : 1;
our $SLSTR = "$SLOWDOWN"; $SLSTR =~ s/\./-/;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;
our $KILL          = defined $opt_k;
our $OTHER_ARGS    = " -y '$SLOWDOWN' -B -Z "; # to RunV2.pl  (dont run with sudo) -s 

our $OUTPUTOPT = defined $opt_o ? $opt_o : "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "_emulab.exp.status";

our ($PUSH_USER, $PUSH_HOST);
($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    rsystem ($PUSH_USER, $PUSH_HOST, sub { psystem ($_[0]); }, $cmd);
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;
    
    if ($CHECK_ONLY) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -C/;
    }
    if ($KILL) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -k/;
    }
    
    my $MAX_RETRIES = 1;
    my $retries = $MAX_RETRIES;
    my $iter = 0;
 
    tinfo "## $name ...";

    psystem ("mkdir -p /tmp/trialsout/$name");

    my $out;

    if (0) {
	for (my $iter = 0; $iter < 2; $iter++) { 
	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -1 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    else {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-succes.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-success.$iter'");
	    }
	}
    }

    if (1) {
	while ($out !~ /ok/ && $retries > 0) {
	    tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < $MAX_RETRIES;

	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -2 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    $retries--;	
	    $iter++;
	}
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################
# our @NODES = (3, 50, 40, 30, 25, 20, 15, 10, 5, 1);
our @NODES = (1, 5, 10, 20, 30, 40, 50);

# our @P2P_NODES = (50, 40, 30, 25, 20, 15, 10, 5, 3, 1);
our @P2P_NODES = ("1:5", "2:5", "1:20", "3:20",
	"5:20", "10:20", "25:20", "50:20");

our @AVAIL_MAPS = ( 100, 10000, 1024, 144, 16, 1600, 196, 2025, 2500, 256, 324, 36, 3600, 4,
	400, 4900, 64, 6400, 784, 8100 );

@AVAIL_MAPS = sort { $a <=> $b } @AVAIL_MAPS;

sub get_map ($$$) {
    my ($n, $v, $k) = @_;
    my $p = $n * $v * $k;

    foreach my $m (@AVAIL_MAPS) {
	if ($m >= $p) {
	    print "choose map with $m players for actually $p players\n";
	    return $m;
	}
    }
    return undef;
}

# rect maps + fed
if (0) {
    ## vary number of nodes

    my $odir = "sd-$SLSTR-rct-nodes";
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    for (my $i=0; $i<@NODES; $i++) {
	my $n = $NODES[$i];
	my $nservers = $n*$VSERVERS;
	my $realtime = $TIME_LIM*$SLOWDOWN;
	my $waitfor  = $realtime;
	my $timemsec = $realtime * 1000;
	my $mapsize = get_map ($n, $VSERVERS, $BOTS);

	exp_psystem("$odir/$nservers",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$VSERVERS' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$odir/$nservers' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m rect_maps/$mapsize-players -b '$BOTS' $OTHER_ARGS");
    }
}

# rect maps + p2p
if (0) { 
    ## set number of bots to 1. 
    my $odir = "sd-$SLSTR-rct-p2p";
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    for (my $i=0; $i<@P2P_NODES; $i++) {
	my $ns = $P2P_NODES[$i];
	
	my ($n, $v) = split (/:/, $ns);
	
	my $nservers = $n*$v;
	my $realtime = $TIME_LIM*$SLOWDOWN;
	my $waitfor  = $realtime;
	my $timemsec = $realtime * 1000;
	my $mapsize = get_map ($n, $v, 1);

	exp_psystem("$odir/$nservers",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$v' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$odir/$nservers' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m rect_maps/$mapsize-players -b '1' $OTHER_ARGS");
    }
}

# square maps + fed
if (0) {
    ## vary number of nodes

    my $odir = "sd-$SLSTR-sqr-nodes";
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    for (my $i=0; $i<@NODES; $i++) {
	my $n = $NODES[$i];
	my $nservers = $n*$VSERVERS;
	my $realtime = $TIME_LIM*$SLOWDOWN;
	my $waitfor  = $realtime;
	my $timemsec = $realtime * 1000;
	my $mapsize = get_map ($n, $VSERVERS, $BOTS);

	exp_psystem("$odir/$nservers",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$VSERVERS' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$odir/$nservers' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m maps/$mapsize-players -b '$BOTS' $OTHER_ARGS");
    }
}

# fixed-size rect map + fed

@NODES = (40);

if (1) {
    ## vary number of nodes

    my $odir = "sd-$SLSTR-fxd-rct-nodes";
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    for (my $i=0; $i<@NODES; $i++) {
	my $n = $NODES[$i];
	my $nservers = $n*$VSERVERS;
	my $realtime = $TIME_LIM*$SLOWDOWN;
	my $waitfor  = $realtime;
	my $timemsec = $realtime * 1000;
	my $mapsize = 1600;             # fixed-size of the map

	exp_psystem("$odir/$nservers",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$VSERVERS' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$odir/$nservers' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m maps/$mapsize-players -b '$BOTS' $OTHER_ARGS");
    }
}

goto done;
# square maps + p2p
if (0) { 
    ## set number of bots to 1. 
    my $odir = "sqr-p2p";
    my $ovser = $VSERVERS;
    my $obots = $BOTS;
    
    $VSERVERS = 8;
    $BOTS = 1;

    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    for (my $i=0; $i<@P2P_NODES; $i++) {
	my $n = $P2P_NODES[$i];
	
	my $nservers = $n*$VSERVERS;
	my $realtime = $TIME_LIM*$SLOWDOWN;
	my $waitfor  = $realtime;
	my $timemsec = $realtime * 1000;
	my $mapsize = get_map ($n, $VSERVERS, $BOTS);

	exp_psystem("$odir/$nservers",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$VSERVERS' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$odir/$nservers' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m maps/$mapsize-players -b '$BOTS' $OTHER_ARGS");
    }

    $VSERVERS = $ovser;
    $BOTS = $obots;
}

if (0) {
    ## vary number of nodes -- with migration
    my $dir = "migrate2";
    special_psystem("mkdir -p '$PUSHLOGDIR/$dir'");
    foreach my $m ("region") { #("load1", "load2", "static", "region") {
	my $n = $NODES[0];
	my $nservers = $n*$VSERVERS;
	my $realtime = $TIME_LIM*$SLOWDOWN;
	my $waitfor  = $realtime + 5*$n; # 5 secs/server
	my $timemsec = $realtime * 1000;
	my $map      = "rect_maps/" . get_map ($n, $VSERVERS, $BOTS) . "-players"; 
	my $pol;
	my $extra;
	    
	if ($m eq "load1") {
	    $pol = "load";
	    $extra = "-I -R";
	} elsif ($m eq "load2") {
	    $pol = "load";
	    $extra = "-I";
	} else {
	    $pol = $m;
	    $extra = "-I";
	}

	exp_psystem("$dir/$m",
		    "./emulab/EmulabRun.pl " .
		    "-E '$MODE' " .
		    "-v '$VSERVERS' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$dir/$m' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m $map -b '$BOTS' -Q '$pol' $OTHER_ARGS $extra");
    }
}

###############################################################################

done:
## done!
print STDERR " ---------- DONE! ---------- \n";
exit 0;
