#!/usr/bin/perl
#
# Run a series of experiment trials on emulab
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C);
use lib "./emulab";
use Travertine;
use EmulabConf;

getopts("n:t:E:v:b:NC");

# defaults
our $MODE          = "";
our $EXP_NAME      = defined $opt_E ? $opt_E : "50lan";
our $MAX_NODES     = defined $opt_n ? $opt_n : 50;
our $TIME_LIM      = defined $opt_t ? $opt_t : 13*60;
our $XTERM         = ""; #"-X";
our $MAP           = "big_map4";
our $VSERVERS      = defined $opt_v ? $opt_v : 1;
our $BOTS          = defined $opt_b ? $opt_b : 8;
our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;

our $OUTPUTOPT = "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "emulab.exp.status";

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    $cmd =~ s/&/\\&/g;
    psystem("ssh $PUSHLOGHOST $cmd");
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;

    if ($CHECK_ONLY) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -C/;
    }

    my $retries = 3;
 
    tinfo "## $name ...";

    my $out;

    while ($out ne 'ok' && $retries > 0) {
        tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < 3;
        $out  = `$cmd`;
        chomp $out;
        $retries--;
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################

our @VARY_NODES    = ( 5, 10, 20, 30, 40, 50 );
our @VARY_BOTS     = ( );
our @VARY_VSERVERS = ( );

if (1) {

    if (0) {
	## vary number of bots
	special_psystem("mkdir -p '$PUSHLOGDIR/bots'");
	foreach my $n (@VARY_BOTS) {
	    special_psystem("mkdir -p '$PUSHLOGDIR/bots/$n'");
	    exp_psystem("bots/$n",
			"./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
			"-v $VSERVERS -b $n " .
			"-I '$IGNORE_NODES' -t $TIME_LIM " .
			"-o '$OUTPUTOPT/bots/$n' -m $MAP " .
			"$EXP_NAME $MAX_NODES");
	}
    }

    if (0) {
	## vary number of vservers
	special_psystem("mkdir -p '$PUSHLOGDIR/vservers'");
	foreach my $n (@VARY_VSERVERS) {
	    special_psystem("mkdir -p '$PUSHLOGDIR/vservers/$n'");
	    exp_psystem("vservers/$n",
			"./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
			"-v $n -b $BOTS " .
			"-I '$IGNORE_NODES' -t $TIME_LIM " .
			"-o '$OUTPUTOPT/vservers/$n' -m $MAP " .
			"$EXP_NAME $MAX_NODES");
	}
    }

    if (1) {
	## vary number of nodes
	special_psystem("mkdir -p '$PUSHLOGDIR/nodes'");
	foreach my $n (@VARY_NODES) {
	    special_psystem("mkdir -p '$PUSHLOGDIR/nodes/$n'");
	    exp_psystem("nodes/$n",
			"./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
			"-v $VSERVERS -b $BOTS " .
			"-I '$IGNORE_NODES' -t $TIME_LIM " .
			"-o '$OUTPUTOPT/nodes/$n' -m $MAP $EXP_NAME $n");
	}
    }
}

###############################################################################

## server scaling exp
if (0) {
    special_psystem("mkdir -p '$PUSHLOGDIR/server_scaling'");
    my %configs = ('10', [ 10, 1, 40 ],
		   '20', [ 20, 1, 20 ], 
		   '40', [ 40, 1, 10 ],
		   '50', [ 50, 1, 8 ],
		   '80', [ 40, 2, 5 ],
                   '100', [ 50, 2, 4 ],
		   #'200', [ 100, 2, 2 ],
		   );

    foreach my $name (keys %configs) 
    {
	my $cur_output_dir = "$PUSHLOGDIR/server_scaling/$name";
	special_psystem("mkdir -p '$cur_output_dir'");
	my $MAX_NODES = $configs{$name}->[0];
	my $VSERVERS = $configs{$name}->[1];
	my $BOTS = $configs{$name}->[2];
	
	exp_psystem("server_scaling/$name",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM ". 
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP $EXP_NAME $MAX_NODES");
    }
}

###############################################################################

## component effects
if (0) {

    if (1) {
	## run with caching off
	my $cur_output_dir = "$PUSHLOGDIR/component/nocache";
	special_psystem("mkdir -p '$cur_output_dir'");
	exp_psystem("component/nocache",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -c $EXP_NAME $MAX_NODES");
    }
    
    if (1) {
	## run with striping off
	my $cur_output_dir = "$PUSHLOGDIR/component/nostriping";
	special_psystem("mkdir -p '$cur_output_dir'");

	exp_psystem("component/nostriping",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -s $EXP_NAME $MAX_NODES");
    }
    
    if (1) {
	## run with prediction off
	my $cur_output_dir = "$PUSHLOGDIR/component/noprediction";
	special_psystem("mkdir -p '$cur_output_dir'");

	exp_psystem("component/noprediction",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -p $EXP_NAME $MAX_NODES");
    }
    
    if (1) {
	## run with prediction and caching off
	my $cur_output_dir = "$PUSHLOGDIR/component/noprediction-nocache";
	special_psystem("mkdir -p '$cur_output_dir'");

	exp_psystem("component/noprediction-nocache",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -p -c $EXP_NAME $MAX_NODES");
    }
    
    if (1) {
	## run with random item partitioning
	my $cur_output_dir = "$PUSHLOGDIR/component/item-partition-r";
	special_psystem("mkdir -p '$cur_output_dir'");

	exp_psystem("component/item-partition-r",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -i r $EXP_NAME $MAX_NODES");
    }
}

###############################################################################

## dht

if (0) {

    my @VARY_NODES = (5, 10, 20, 30, 40, 50);

    for my $n (@VARY_NODES) {
	## run with caching on
	my $cur_output_dir = "$PUSHLOGDIR/dht-cache/$n";
	special_psystem("mkdir -p '$cur_output_dir'");

	exp_psystem("dht-cache/$n",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -D $EXP_NAME $n");
    }

    {
	## run with caching off
	my $cur_output_dir = "$PUSHLOGDIR/dht-nocache";
	special_psystem("mkdir -p '$cur_output_dir'");
	
	exp_psystem("dht-nocache",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $VSERVERS -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$PUSHLOGHOST:$cur_output_dir' " .
		    "-m $MAP -D $EXP_NAME $MAX_NODES");
    }

}

###############################################################################

my @VARY_NODES_2X = ( 25, 30, 40, 50 );

if (0) {

    ## vary number of nodes with 2x vservers
    special_psystem("mkdir -p '$PUSHLOGDIR/nodes'");
    foreach my $n (@VARY_NODES_2X) {
        special_psystem("mkdir -p '$PUSHLOGDIR/nodes/$n-2x'");
        exp_psystem("nodes/$n-2x",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v " . (2*$VSERVERS) . " -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$OUTPUTOPT/nodes/$n-2x' -m $MAP $EXP_NAME $n");
    }
}

if (0) {

    ## vary number of nodes with 2x vservers
    special_psystem("mkdir -p '$PUSHLOGDIR/dht-cache'");
    foreach my $n (@VARY_NODES_2X) {
        special_psystem("mkdir -p '$PUSHLOGDIR/dht-cache/$n-2x'");
        exp_psystem("dht-cache/$n-2x",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v " . (2*$VSERVERS) . " -b $BOTS " .
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$OUTPUTOPT/dht-cache/$n-2x' -D -m $MAP $EXP_NAME $n");
    }
}

###############################################################################

if (1) {

   my @P2P_NODES = ( 1, 3, 7, 8, 30, 40, 50 ); # 5, 10, 20
   my $P2P_VSERVERS = 3;
   my $P2P_BOTS = 1;
   
    ## vary number nodes in a "p2p" game
    special_psystem("mkdir -p '$PUSHLOGDIR/nodes'");
    foreach my $n (@P2P_NODES) {
        special_psystem("mkdir -p '$PUSHLOGDIR/p2p/$n'");
        exp_psystem("p2p/$n",
		    "./emulab/EmulabRun.pl -E '$MODE' $XTERM " .
		    "-v $P2P_VSERVERS -b $P2P_BOTS -M 0 -F " . 
		    "-I '$IGNORE_NODES' -t $TIME_LIM " .
		    "-o '$OUTPUTOPT/p2p/$n' -m $MAP $EXP_NAME $n");
    }
}

###############################################################################

## done!
print STDERR " ---------- DONE! ---------- \n";
exit 0;
