#!/usr/bin/perl
#
# Process results generated from EmulabTrials.pl
#

use strict;
use IO::File;
use lib "./emulab";
require "inc.pl";
use EmulabConf;

#
# Each trial point has the following statistics calculated for it.
#
# ( stat_name => [ log_regex, process_func ] )
#
# stat_name    - name of the statistic (used in filename)
# log_regex    - regex for logs that we want to process
# process_func - function to do the processing with the prototype
#                f($fh, $pt, @logs) where:
#                $fh   = the filehandle to write results to
#                $pt   = the value of the point we are evaluating
#                @logs = the full path to all logs to process
#
my %stats = ( "bwidth" => [ "^MessageLog\.*",      \&do_bwidth ],
	      "dislat" => [ "^DiscoveryLatLog\.*", \&do_dislat ], );

opendir(DIR, "$OUTPUTDIR") || die "can't open $OUTPUTDIR: $!";
my @exps = readdir(DIR);
close(DIR);

foreach my $exp (@exps) {
    next if $exp =~ /^\./;

    opendir(EXP, "$OUTPUTDIR/$exp") || die "can't open $OUTPUTDIR/$exp";
    my @points = readdir(EXP);
    close(EXP);
    
    my %files;
    foreach my $k (keys %stats) {
	$files{$k} = new IO::File(">$exp.$k.results");
	die "can't open $exp.$k.results" if ! $files{$k};
    }

    foreach my $pt (@points) {
	next if $pt =~ /^\./;

	opendir(EXP, "$OUTPUTDIR/$exp/$pt") || 
	    die "can't open $OUTPUTDIR/$exp/$pt";
	my @logs = readdir(EXP);
	close(EXP);

	foreach my $k (keys %stats) {
	    my ($regex, $func) = @{$stats{$k}};
	    my @todo = ();
	    foreach my $log (@logs) {
		push @todo, "$OUTPUTDIR/$exp/$pt/$log" if $log =~ /$regex/;
	    }
	    print STDERR "processing: $exp $pt $k...\n";
	    &{$func}($files{$k}, $pt, @todo);
	}
    }

    foreach my $k (keys %stats) {
	close( $files{$k} )
    }
}

sub do_bwidth {
    my $fh   = shift;
    my $pt   = shift;
    my @logs = @_;

    print $fh ">>> $pt:\n\n";
    
    foreach my $log (sort { $a cmp $b } @logs) {
	if ($log =~ /MessageLog\.(.*)\.log/) {
	    my $sid = $1;
	    print $fh "$sid:\n\n";
	    open(PIPE, "$MERCDIR/scripts/MessageLogAggregate.pl -s 60 -l 360 $log |") || 
		die "can't open pipe!";
	    while (<PIPE>) {
		print $fh $_;
	    }
	    print $fh "\n";
	} else {
	    warn "log has bad name: $log";
	}
    }
}

sub do_dislat {
    my $fh   = shift;
    my $pt   = shift;
    my @logs = @_;

    print $fh ">>> $pt:\n\n";

    open(PIPE, "$MERCDIR/scripts/SubDiscoveryTime.pl -s 60 -l 360 " . 
	 join(" ", @logs) . " |") || die "can't open pipe!";
    while (<PIPE>) {
	print $fh $_;
    }
    print $fh "\n";
}
