#!/usr/bin/perl
#
# For Jeff and Haifeng's filesystem stuff.
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C $opt_k $opt_o $opt_y);
use lib "./emulab";
use Travertine;
use EmulabConf;

getopts("n:t:E:v:b:NCko:y:");

our $APPCONF       = "StoreServerConf.pl";

# defaults
our $MODE          = "";
our $EXP_NAME      = defined $opt_E ? $opt_E : "fc4-10";
our $MAX_NODES     = defined $opt_n ? $opt_n : 10;
# virtual time (exp time *= slowdown)
our $TIME_LIM      = defined $opt_t ? $opt_t : 8*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 5;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;
our $KILL          = defined $opt_k;
our $OTHER_ARGS    = " -B -Z "; # to RunV2.pl  (dont run with sudo) -s 

our $OUTPUTOPT = defined $opt_o ? $opt_o : "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "_emulab.exp.status";

our ($PUSH_USER, $PUSH_HOST);
($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    rsystem ($PUSH_USER, $PUSH_HOST, sub { psystem ($_[0]); }, $cmd);
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;
    
    if ($CHECK_ONLY) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -C/;
    }
    if ($KILL) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -k/;
    }
    
    my $MAX_RETRIES = 1;
    my $retries = $MAX_RETRIES;
    my $iter = 0;
 
    tinfo "## $name ...";

    psystem ("mkdir -p /tmp/trialsout/$name");

    my $out;

    if (0) {
	for (my $iter = 0; $iter < 2; $iter++) { 
	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -1 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    else {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-succes.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-success.$iter'");
	    }
	}
    }

    if (1) {
	while ($out !~ /ok/ && $retries > 0) {
	    tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < $MAX_RETRIES;

	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -2 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    $retries--;	
	    $iter++;
	}
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################
# our @NODES = (3, 50, 40, 30, 25, 20, 15, 10, 5, 1);
our @NODES = (10);

if (1) {
    ## vary number of nodes

    my $odir = "test";
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    for (my $i=0; $i<@NODES; $i++) {
	my $n = $NODES[$i];
	my $nservers = $n*$VSERVERS;
	my $realtime = $TIME_LIM;
	my $waitfor  = $realtime;
	my $timemsec = $realtime * 1000;

	exp_psystem("$odir/$nservers",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$VSERVERS' " .
		    "-I '$IGNORE_NODES' " .
		    "-o '$OUTPUTOPT/$odir/$nservers' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-M -A $OTHER_ARGS");
	# -M no manager opts
	# -A no latency
    }
}


###############################################################################

done:
## done!
print STDERR " ---------- DONE! ---------- \n";
exit 0;
