#!/usr/bin/perl

use strict;
use Travertine;

our $LOCAL;
our $EXP;
our $TIMES_FILE;
our @TIMES;

our $TIME_LIMIT = 30*60;
our $SAVEDIR = "jeffpang\@humpback.cmcl.cs.cmu.edu:/home/jeffpang/logs";
our %CONF = (
	      4   => [1,4],
	      16  => [8,2],
	      100 => [10,10],
	      200 => [20,10],
	      500 => [50,10],
	      1000 => [50, 20] );

our %SKIP;

sub init($$$) 
{
    ($LOCAL, $EXP, $TIMES_FILE) = @_;

    open(T, "<$TIMES_FILE") or tdie "can't open $TIMES_FILE: $!";
    my $line = <T>;
    chomp $line;
    close(T);

    @TIMES = split(/,/, $line);

    if (!@TIMES) {
	tdie "no times in $TIMES_FILE";
    }
}

sub skip($)
{
    $SKIP{$_[0]} = 1;
}

sub run($$$$@)
{
    my ($OUT, $NODES, $TYPE, $TRACE, @OPTS) = @_;

    my $EXTRA = join(" ", @OPTS);

    my $PREF;
    if ($LOCAL eq 'local') {
	$PREF = "test";
    } elsif ($LOCAL eq 'iris') {
	$PREF = "harvard";
    } else {
	$PREF = "harvard";
    }

    my $KEY;
    if ("$TYPE" eq "rand") {
	$KEY=80;
    } elsif ($TYPE eq "randfile") {
	$KEY=160;
    } else {
	$KEY=512;
    }

    # all preimages are in the 200 dir (hack!)
    if ($LOCAL ne 'local') {
        $EXTRA .= " --preimage-dir $PREF.$TYPE.200 ";
    }

    foreach my $t (@TIMES) {
	tinfo "###### $NODES/$OUT/$TYPE/$TRACE/$t";

	if ($SKIP{"$NODES/$OUT/$TYPE/$TRACE/$t"}) {
	    tinfo "skipping...";
	    next;
	}
	
	if ($LOCAL ne 'local') {
            $SAVEDIR =~ /(.*?):(.*)/;
	    my ($host, $dir) = ($1, $2);
	    psystem "ssh $host mkdir -p '$dir/$NODES/$OUT/$TYPE/$TRACE/$t'";
	}

	my $cmd;
	if ($LOCAL eq 'local') {
	    $cmd = "./RunV2.pl StoreServerConf.pl localhost " .
		"-g -v $NODES -A --flushimmed" .
		" --min-replicas 1 ";
	} elsif ($LOCAL eq 'iris') {
	    my $nodes = $CONF{$NODES}->[0];
	    my $vservers = $CONF{$NODES}->[1];

	    $cmd = "./iris/LocalRun.pl -t $TIME_LIMIT " .
		" -o '$SAVEDIR/$NODES/$OUT/$TYPE/$TRACE/$t' " .
		" StoreServerConf.pl $nodes -v $vservers -Z -B -A " .
		#" --waspnet " .
		#" --latency emulab.n50.v20.0.0.waspnet " .
		#" --waspnet-out $OUT " .
		" --min-replicas 3 ";
	} else {
	    my $nodes = $CONF{$NODES}->[0];
	    my $vservers = $CONF{$NODES}->[1];

	    $cmd = "./emulab/EmulabRun.pl -t $TIME_LIMIT " .
		" -o '$SAVEDIR/$NODES/$OUT/$TYPE/$TRACE/$t' " .
		" StoreServerConf.pl $EXP $nodes -v $vservers -Z -B " .
		" --spbootstrap " .
		" --waspnet " .
		" --latency emulab.n50.v20.0.0.waspnet " .
		" --waspnet-out $OUT " .
		" --min-replicas 3 ";
	}

        $cmd .=
	    #" --tcp-mesh " .
	    " --nosleep --verbosity -10 " .
	    " --key-size $KEY " .
	    " --trace-time $t " .
	    " --initial-dir $PREF.$TYPE.$NODES " .
	    " --trace-dir $PREF/$TYPE/$TRACE " .
	    " --logenableonly AggregateMessageLog,DiscoveryLatLog,TraceClientLog" .
	    " $EXTRA ";

	if ($LOCAL) {
	    $cmd .= ">/tmp/local.exp";
	}

	psystem $cmd;
	
	if ($LOCAL eq 'local') {
	    sleep($TIME_LIMIT);
	}
    }
}

1;
