#!/usr/bin/env python

# Written by Bram Cohen
# see LICENSE.txt for license information
#
# $Id: btpull.py 2468 2005-11-11 20:16:10Z jeffpang $
# changed by Ashwin Bharambe for doing some reporting...
#
# this script downloads stuff and reports to the watchdog about its progress

from BitTorrent.download import download
from BitTorrent.bencode import bencode
from threading import Event
from os.path import abspath
from sys import argv, stdout, exit
import sys
from cStringIO import StringIO
from time import time
import socket, signal

WATCHDOG_PORT = 60001

def hours(n):
    if n == -1:
        return '<unknown>'
    if n == 0:
        return 'complete!'
    n = long(n)
    h, r = divmod(n, 60 * 60)
    m, sec = divmod(r, 60)
    if h > 1000000:
        return '<unknown>'
    if h > 0:
        return '%d hour %02d min %02d sec' % (h, m, sec)
    else:
        return '%d min %02d sec' % (m, sec)

class HeadlessDisplayer:
    def __init__(self, watchdog):
        self.done = False
        self.percentDone = '0'
        self.timeEst = ''
        self.downRate = '0'
        self.errors = []
        self.upRate = '0'
        self.last_update_time = 0
        self.sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.watchdog = socket.gethostbyname(watchdog)
        self.trying_counter = 0

    def finished(self):
        self.done = True
        self.percentDone = '100'
        self.timeEst = 'Download Succeeded!'
        self.display({})

    def failed(self):
        self.done = True
        self.percentDone = '0'
        self.timeEst = 'Download Failed!'
        self.downRate = '0'
        self.display({})

    def error(self, errormsg):
        self.errors.append(errormsg)
        self.display({})

    def record_problem(self):
        self.trying_counter += 1
        if self.trying_counter >= 100:   # over 300 seconds == 5 minutes, we are trying to connecting to peers
            print >>sys.stderr, "giving up connecting to the tracker or peers"
            sys.exit(1)
        
    def display(self, dict):
        if self.last_update_time + 3 > time():
            return
        
        self.last_update_time = time()
        
        if dict.has_key('fractionDone'):
            self.percentDone = str(float(int(dict['fractionDone'] * 1000)) / 10)
        if dict.has_key('timeEst'):
            self.timeEst = hours(dict['timeEst'])
        if dict.has_key('activity') and not self.done:
            self.timeEst = dict['activity']
        if dict.has_key('downRate'):
            self.downRate = '%.2f kB/s' % (float(dict['downRate']) / (1 << 10))
        if dict.has_key('upRate'):
            self.upRate = '%.2f kB/s' % (float(dict['upRate']) / (1 << 10))

        kv = {}
        kv['percentDone'] = self.percentDone
        kv['timeEst'] = self.timeEst
        kv['downRate'] = self.downRate
        kv['upRate'] = self.upRate
        kv['errors'] = self.errors

        if dict.has_key('activity') and dict['activity'] == 'connecting to peers':
            self.record_problem()

        for err in self.errors:
            if err.find("Problem connecting to tracker") != -1:
                self.record_problem()
        
        self.sock.sendto(bencode(kv), (self.watchdog, WATCHDOG_PORT))
        for k, v in kv.iteritems():
            print >>sys.stderr, "%s=%s " % (k, v),
        print >>sys.stderr, ""

    def chooseFile(self, default, size, saveas, dir):
        if saveas != '':
            default = saveas
        return default

    def newpath(self, path):
        pass

def run(params):    
    h = HeadlessDisplayer(params[0])     # make sure the first argument is the watchdog server

#     def quit(n, f):
#         exit(0)

#     signal.signal(signal.SIGTERM, quit)
#     signal.signal(signal.SIGQUIT, quit)
#     signal.signal(signal.SIGINT, quit)
    
    params = params[1:]
    download(params, h.chooseFile, h.display, h.finished, h.error, Event(), 80, h.newpath)
    if not h.done:
        h.failed()

if __name__ == '__main__':
    run(argv[1:])
