#
# Run.pl configuration for Mercapp
#

use strict;
use Travertine;
use Options;
use vars qw($opt_client $opt_trace $opt_trace_start $opt_store_opts
	    $opt_min_replicas $opt_initial_dir $opt_preimage_dir $opt_tcp_mesh 
	    $opt_keysize $opt_trace_time $opt_waitjoin $opt_t);

our $STOREPORT_BASE = 40000;

our @RPC_PORTS = 
    (12000,12001,12002,12003,12004,12005,12006,12007,12008,12009,
     12010,12011,12012,12013,12014,12015,12016,12017,12018,12019);

###############################################################################

our @APP_INST_DIST = (
      "D2/build/store",
      "D2/build/*.cfg",
      "D2/build/initial_data/harvard.randfile.*",
      "D2/build/traces/harvard/randfile",
      #"D2/*.so",
      "Merc/build/bootstrap",
      "Merc/build/chkjoin2",
      "Merc/configs/*.conf",
      "Merc/configs/*.cfg",
      "Merc/*.so*",
      #"Merc/util/time-test/client",
      #"Merc/util/time-test/server",

      "Colyseus/scripts/Topology2Waspnet.pl",
      "Data/topologies/emulab.*",
      "Colyseus/run/emulab/util",
);

our $APP_INST_PRE = sub {
    my $topdir = shift;
    my $username = shift;
    
    my $owner = getpwuid((stat($topdir))[4]);

    if ($owner ne $username) {
	#tinfo "using sudo since $owner != $username";
	psystem("sudo mkdir -p $topdir");
	psystem("sudo chown $username $topdir");
    } else {
	psystem("mkdir -p $topdir");
    }
};

our $APP_INST_POST = sub {
    my $topdir = shift;
    my $username = shift;

    my $owner = getpwuid((stat($topdir))[4]);

    if ($owner ne $username) {
	psystem("sudo mkdir -p $topdir/db");
	psystem("sudo chown $username $topdir/db");
    } else {
	psystem("mkdir -p $topdir/db");
    }
};

# directory containing $APP_EXE in relation to $TOPDIR
# our $APP_DIR = "Merc/apps/testgame";
our $APP_DIR = "D2/build";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "store";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = "..:../../Colyseus:../../Merc";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../../Merc/build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../../Data/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = ""; # set later

#our $APP_PARAMS_CONF = "../../../Merc/build/params.conf";
our $APP_PARAMS_CONF = "../../Merc/configs/params_defrag.conf";

our $APP_TOPO2WASPNET = "../../Colyseus/scripts/Topology2Waspnet.pl";

###############################################################################

# application script parameters (passed to perl script)
our @APP_OPT_TABLE = (
 #Options::String("#", "client", "store client {term,trace,none}", \$opt_client, "term"),
 Options::String("#", "key-size", "key size (must have schema!)", \$opt_keysize, "512"), 
 Options::Boolean("#", "tcp-mesh", "init tcp mesh with servers in ident.map", \$opt_tcp_mesh), 
 Options::String("#", "min-replicas", "minimum replicas", \$opt_min_replicas, "4"),
 Options::String("#", "trace-time", "use trace starting at this time", \$opt_trace_time, "test"),
 Options::String("#", "trace-dir", "trace dir for each trace client (from defrag/build/traces", \$opt_trace, undef),
 Options::String("#", "trace-start", "trace start time for trace client", \$opt_trace_start, "0.0"),
 Options::String("#", "initial-dir", "directory (from defrag/build/initial_data) containing initial data", \$opt_initial_dir, undef),
 Options::String("#", "preimage-dir", "directory (from defrag/build/initial_data) containing preimage data", \$opt_preimage_dir, undef),
 Options::String("#", "store-opts", "other common store arguments", \$opt_store_opts, ""),
);

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

our $APP_BOOTSTRAP_ARGS;

our $APP_NSERVERS;
our %ABS_SERVER_INDEX;
our %ABS_SERVER_INDEX_REV;

our @CLIENTS;
our %PREDS;

our $APP_TOPDIR;
our $LOCAL_APP_DIR = "../../D2/build";

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers = shift;
    my @logins   = map { [ split(/\@|:/, $_) ] } @_;
    $APP_NSERVERS = $vservers * scalar @logins;
    $APP_TOPDIR = $opt_t || "/tmp";

    my $abs_index = 0;
    # XXX: this used to do round-robin allocation, but we can't do that
    # because the ident.map will have all the vservers on one node in
    # a group, so we have to allocate in the same order, otherwise the
    # wrong data files will be placed on the wrong nodes.
    for (my $i=0; $i<@logins; $i++) {
	for (my $j=0; $j<$vservers; $j++) {
	    
	    my $port = $STOREPORT_BASE + $j;
	    my $addr = $logins[$i]->[2] . ":" . $port;
	    $ABS_SERVER_INDEX{ $addr } = $abs_index;
	    $ABS_SERVER_INDEX_REV{ $abs_index } = $addr;
	    $abs_index++;   
	}
    }

    my $common = "$opt_store_opts --use-local-merc --store-min-replicas $opt_min_replicas --store-key-size $opt_keysize --store-db-fake ";
    $common .= " --succ-wait-alljoin --nosuccdebug ";

    my $master = $logins[0]->[2] . ":42331";
    $common .= " --store-barrier-master $master --store-barrier-count $APP_NSERVERS ";

    #if (!$opt_waitjoin) {
    #	$common .= " --no-merc-alljoin ";
    #}
    # force this for stability

    my $identmap = "ident.map";
    if ($opt_tcp_mesh) {
	$common .= " --tcp-mesh initial_data/$opt_initial_dir/$opt_trace_time/$identmap";
    }

    $APP_MASTER_ARGS = $APP_SLAVE_ARGS = $common;

    $APP_SCHEMA = "schema_defrag.$opt_keysize.cfg";

    #$APP_MASTER_ARGS = "$common --store-client term";
    #$APP_MASTER_ARGS = "$common --store-client trace,term --store-client-trace-file traces/$opt_trace --store-client-trace-start-time $opt_trace_start";
    #$APP_SLAVE_ARGS  = "$common --store-client term";

    # xxx: hack the path
    if (defined $opt_trace && $opt_trace ne "") {
	# the client list is the same for all times within a given exp
	# which ensures that the same client gets mapped to the same node
	# in each time for the exp
	open(C, "<$LOCAL_APP_DIR/traces/$opt_trace/client.list") or tdie "can't open $LOCAL_APP_DIR/traces/$opt_trace/client.list: $!";
	while (<C>) {
	    chomp;
	    push @CLIENTS, $_;
	}
    }

    if (!defined $opt_preimage_dir) {
	$opt_preimage_dir = $opt_initial_dir;
    }

    my $nclients = scalar @CLIENTS;
    tinfo "$nclients trace clients, will use " . ($nclients > $APP_NSERVERS ? $APP_NSERVERS : $nclients) . " of them";

    if (defined $opt_initial_dir && $opt_initial_dir ne "") {
	$APP_BOOTSTRAP_ARGS = " --ident-map initial_data/$opt_initial_dir/$opt_trace_time/$identmap --policy ident-map";
	# force this for stability
	if (!$opt_waitjoin) {
	    $APP_BOOTSTRAP_ARGS .= " --nservers $APP_NSERVERS ";
	}

	# xxx hack the path
	my $identmap = "$LOCAL_APP_DIR/initial_data/$opt_initial_dir/$opt_trace_time/$identmap";
	loadIdentMap($identmap);
    }
};

sub loadIdentMap
{
    my $f = shift;
    my @order;

    my $chars = $opt_keysize/8*2;

    open(F, "<$f") or tdie "can't open $f";
    my $index = 0;
    while (<F>) {
	chomp;
	my ($hubid, $addr, $id) = split(/\t/, $_);
	while (length $id < $chars) {
	    $id = "0$id";
	}
	
	push @order, [$index, $addr, $id];
	$index++;
    }
    close(F);
    
    @order = sort { $a->[2] cmp $b->[2] } @order;

    #tinfo "order:";
    #print STDERR (join("\n", map { "$_->[2]" } @order), "\n");

    for (my $i=0; $i<@order; $i++) {
	my @preds;
	for (my $j=1; $j<=$opt_min_replicas; $j++) {
	    push @preds, $order[($i-$j) % scalar @order]->[0];
	}
	$PREDS{$order[$i]->[0]} = \@preds;
	#tinfo "@{$order[$i]}: " . join(" ", @preds);
    }

}

sub cannonId
{
    our $CANNON_LENGTH = 64*2; # assume all ids < 128 chars
    my $id = shift;
    my $len = length $id;
    if ($len < $CANNON_LENGTH) {
	$id = ("0" x ($CANNON_LENGTH-$len)) . $id;
    }
    return $id;
}

sub loadPreimageMap 
{
    my $file = shift;
    my @map;

    open(F, "<$file") || tdie "can't open $file: $!";
    while(<F>) {
	chomp;
	if (/(\d+)\t(\w+)\t(\w+)/) {
	    my ($fid, $min, $max) = ($1,$2,$3);

	    push @map, [$fid, cannonId($min), cannonId($max)];
	} else {
	    twarn "bad line in preimage map $file: $_"; 
	}
    }

    return \@map;
}

sub getRange
{
    my $info = shift;
    
    open(I, "<$info") || tdie "can't open $info: $!";
    while (<I>) {
	chomp;
	if (/range\t\[(\w+),(\w+)\]/) {
	    my ($min, $max) = ($1, $2);
	    return [cannonId($min), cannonId($max)];
	}
    }

    tdie "can't find range in $info";
}

sub betweenbothincl($$$) {
    my ($a, $b, $n) = @_;
    my $r;
    if (($a eq $b) && ($n eq $a)) {
	$r = 1;
    } elsif ($a le $b) {
	$r = ($n ge $a) && ($n le $b);
    } else {
	$r = ($n ge $a) || ($n le $b);
    }
    return $r;
}

sub _overlapsbothincl($$)
{
    my ($a, $b) = @_;

    return betweenbothincl($a->[0], $a->[1], $b->[0]) ||
	betweenbothincl($a->[0], $a->[1], $b->[1]);    
}

sub overlapsbothincl($$)
{
    my ($a,$b) = @_;
    return _overlapsbothincl($a, $b) || _overlapsbothincl($b, $a)
}

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my @login = split(/\@|:/, shift());
    my $vindex = shift;
    my $port = $STOREPORT_BASE + $vindex;

    my $addr = $login[2] . ":" . $port;
    my $aindex = $ABS_SERVER_INDEX{ $addr };
    if (!defined $aindex) {
	tdie "missing absolute index for @login vserver $vindex";
    }
    #tinfo "$login[1]:$vindex $aindex";

    my $dbname = "$APP_TOPDIR/db/store.$login[2].$port.db";

    my $opts = " --store-rpc-port $port --store-db-name $dbname ";
    if (defined $opt_initial_dir && $opt_initial_dir ne "") {
	my @files;
	my @ranges;

	foreach my $index ($aindex, @{$PREDS{$aindex}}) {
	    my $f = "initial_data/$opt_initial_dir/$opt_trace_time/info.log.$index";
	    push @files, $f;
	    push @ranges, getRange("$LOCAL_APP_DIR/$f");
	}

	if (@files > 0) {
	    $opts .= " --store-initial-data-files " . join(",", @files);
	}

	my @preimage_pref = ( "initial_data/$opt_preimage_dir/preimage.log.shared", "initial_data/$opt_preimage_dir/$opt_trace_time/preimage.log" );
	my @preimages;
	foreach my $pref (@preimage_pref) {
	    my $map = loadPreimageMap("$LOCAL_APP_DIR/$pref.map");
	    foreach my $chunk (@$map) {
		my $id = $chunk->[0];
		my $cr = [ $chunk->[1], $chunk->[2] ];
		foreach my $r (@ranges) {
		    if (overlapsbothincl($r, $cr)) {
			#tinfo "[$r->[0],$r->[1]]  [$cr->[0],$cr->[1]]"; 

			push @preimages, "$pref.$id";
			last;
		    }
		}
	    }
	}
 
	if (@preimages > 0) {
	    $opts .= " --store-initial-data-size-file " . join(",", @preimages);
	}
    }

    if ($aindex < @CLIENTS) {
	my $tfile = "$LOCAL_APP_DIR/traces/$opt_trace/$opt_trace_time/session_trace.$CLIENTS[$aindex].log";
	if (-f $tfile) {
	    $tfile =~ s|$LOCAL_APP_DIR|.|;
	    $opts .= " --store-client trace --store-client-trace-file $tfile --store-client-trace-start-time $opt_trace_start ";
	}
	my $cfile = "$LOCAL_APP_DIR/initial_data/$opt_initial_dir/$opt_trace_time/client.log.$CLIENTS[$aindex]";
	if (-f $cfile) {
	    $cfile =~ s|$LOCAL_APP_DIR|.|;
	    $opts .= " --store-cache-file $cfile ";
	}
    }
    $opts .= " --store-client-delay 0 ";

    my $bport = 42331 + $vindex;
    $opts .= " --store-barrier-port $bport ";

    return $opts;
};

1;
