#
# Run.pl configuration for Quake3
#

use strict;
use Options;
use Travertine;
use vars qw($opt_d $opt_b $opt_e $opt_maxclients $VISUALIZER $opt_m $NMASTERS $BPATTERNS $MERC_LOADBAL);

our @QUAKE_PORTS = 
    (27960,27961,27962,27963,27964,27965,27966,27967,27968,27969,
     27970,27971,27972,27973,27974,27975,27976,27977,27978,27979);

###############################################################################
# The files to copy over to the remote host (relative to TOPDIR)
# (may be globs of files, but not of nested directories: ../*/*.. doesn't work)
# Do NOT include trailing slashes
#
our @APP_INST_DIST = (
      "Data/baseq3",
      "quake3/src/colyquake3",
      "quake3/src/apps/bboxgen/bboxgen",
      "quake3/src/apps/iquake3/iquake3",
      "quake3/src/bbox",
      "Merc/build/bootstrap",
      "Merc/build/chkjoin2",
      "Merc/configs/params.conf",
      "Merc/configs/*.cfg",
      "Merc/*.so",
      "Colyseus/*.so",
      "Data/topologies/*.lat",
      #"Merc/util/time-test/client",
      #"Merc/util/time-test/server",
      "Colyseus/scripts/Topology2Waspnet.pl",
      "Data/topologies/emulab.*",
      "Colyseus/run/emulab/util",
	);

# Function to execute on remote host before sync
#
our $APP_INST_PRE = sub {
    my $topdir = shift;
    my $username = shift;

    psystem("mkdir -p $topdir");
    psystem("chown $username $topdir");
};

# Function to execute on the remote host after sync
#
our $APP_INST_POST = sub {
    my $topdir = shift;

    psystem "mkdir -p $ENV{HOME}/.q3a";

    my %links =
	( "$ENV{HOME}/.q3a/baseq3" => "$topdir/Data/baseq3",
	  "$topdir/quake3/colyquake3" => "$topdir/quake3/src/colyquake3",
	  "$topdir/quake3/bbox" => "$topdir/quake3/src/bbox" );

    chdir($topdir) or twarn "can't chdir $topdir";
    foreach my $from (keys %links) {
	psystem "rm -f $from";
	psystem "ln -sf $links{$from} $from";
    }

    psystem "cp -f $topdir/Merc/configs/params.conf $topdir/quake3";

    # chmod to correct permissions
    foreach my $dir ("Merc", "Colyseus", "Data", "quake3") { 
        psystem("chmod -R g+rw $topdir/$dir >/dev/null 2>&1");
    }
   
    # for stupid bittorrent which does not keep the permissions :(
    # or perhaps for stupid me who cant figure out how to make it 
    # preserve them. - Ashwin [08/21/2005]
    
    foreach my $prog ("Merc/build/bootstrap", "Merc/build/chkjoin2", 
		      "quake3/src/colyquake3", 
		      "quake3/src/apps/bboxgen/bboxgen",
		      "quake3/src/apps/iquake3/iquake3") 
    {
        psystem("chmod +x $topdir/$prog");
    }
};


# directory containing $APP_EXE in relation to $TOPDIR
our $APP_DIR = "quake3";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "colyquake3";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = ".:../Merc:../Colyseus:/usr/local/lib";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../Merc/build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../Data/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = ""; # set later in APP_HANDLE_ARGS;

our $APP_PARAMS_CONF = "../Merc/configs/params.conf";

###############################################################################
our $DO_MEASUREMENT;
our $MERC_LOADBAL = "";
our $ENABLE_STRIPING = undef;
our $NO_BBOX = undef;

# application script parameters (passed to perl script)
our @APP_OPT_TABLE = 
(
 Options::String("/", "bpatterns", "benchmark patterns", \$BPATTERNS, undef),
 Options::String("/", "nmasters", "number of master servers", \$NMASTERS, "1"),
 Options::String("m", "map", "map name", \$opt_m, undef),
 Options::String("b", "nbots", "bots on each server (or comma separated list of bots on each servers)", \$opt_b, undef),
 Options::String("e", "timelimit", "time limit in msec", \$opt_e, undef),
 Options::String("z", "vis-ip", "visualizer IP addr", \$VISUALIZER, undef),
 Options::Boolean("/", "merclb", "perform mercury load balancing", \$MERC_LOADBAL),
 Options::String("/", "maxclients", "max players allowed on each server", \$opt_maxclients, "64"),
 Options::Boolean("d", "deltas", "use --deltas", \$opt_d),
 Options::Boolean("/", "nobbox", "dont use any bbox-file", \$NO_BBOX),
);

our @NUMBOTS;

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers  = shift;
    my @servers   = @_;
    my $nservers  = scalar(@_)*$vservers;

    my $MAP               = $opt_m || "q3dm1";
    my $NUMBOTS           = defined $opt_b ? $opt_b : 1;

    @NUMBOTS = split(/,/, $NUMBOTS);

    my $DELTAS            = defined $opt_d;
    
    $APP_SCHEMA = "../Merc/configs/schema_quake_twohubs.cfg";

    ##########

    my $bpattern_args = "";
    if ($BPATTERNS) {
	$bpattern_args = "--benchmark-patterns '$BPATTERNS' ";
    }
    my $visualizer_args = "";
    if ($VISUALIZER) {
	$visualizer_args = " --visualizer-ip '$VISUALIZER' ";
    }
    my $delta_args = "";
    if ($DELTAS) {
	$delta_args = "--deltas --no-clusters";    # disable clustering of fields if we are recording deltas
    }

    my $debug_args = "+set showpackets 1 +set showdrop 1";
    my $common_args =
	"--master-servers $NMASTERS " .
	"--nosuccdebug " .
	"$bpattern_args " .
	"$visualizer_args " .
	"$delta_args " .
	"--map $MAP ";

    if ($NO_BBOX) {
	# do nothing;
    }
    else {
	$common_args .= "--bbox-file bbox/$MAP.bbox ";
    }
    $common_args .= "+set ttycon 0 +set dedicated 1 +set sv_maxclients $opt_maxclients +bot_developer 0 ";

    my (undef, undef, $master) = 
	($servers[0] =~ /^([^\@]+)\@([^:]+):([^:]+)$/);
    tdie "bad master login: $servers[0]" if !$master;

    my $merc_bounds = "x -1000000000 1000000000,y -1000000000 1000000000,z -1000000000 1000000000";
    $common_args .= " --mercbounds '$merc_bounds' ";

    if (defined $MERC_LOADBAL) {
	$common_args .= " --sampling --selfhistos --loadbal-routeload --load-balance --load-balance-delta 2.0 ";
    }

    $APP_MASTER_ARGS = "$common_args";
    $APP_SLAVE_ARGS = "$common_args";

    #tinfo "$APP_SLAVE_ARGS";
};

our $INDEX = 0;
our $MASTERS_DONE = 0;

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my $login = shift;
    my $vindex = shift;
    my $timelimit = $opt_e || 1000000000;

=start    
    # randomize a little to test; dont do the srand before     
    # because this can get invoked after a fork (via ParallelExec)
    # and then the random numbers wont be distinct for two subtrees!

    srand (time ^ $$);
    $timelimit += (-15000 + int (rand (30000)));
=cut

    my $ret = " --timelimit $timelimit +set net_port $QUAKE_PORTS[$vindex] ";

    if ($MASTERS_DONE < $NMASTERS) {
	$MASTERS_DONE++;
	$ret .= " --master-index $MASTERS_DONE ";
    } else {
	$ret .= " --master-index 0 ";
    }

    if (scalar @NUMBOTS == 1) {
	$ret .= "--nbots $NUMBOTS[0] ";
    } else {
	my $bots = $INDEX < scalar @NUMBOTS ? $NUMBOTS[$INDEX] : 0;
	$ret .= "--nbots $bots ";
    }

    #tinfo "$INDEX: $ret";

    $INDEX++;

    return $ret;
};

1;
