#!/usr/bin/perl
use strict;
use Travertine;
use Options;

##################################################################
#  Produce a dummy ".exp" file which can be used to feed to 
#  other scripts like TermExec.pl, for example.

use vars qw($HOSTS $VSERVERS);
my @options = (
    [ "H", "hosts", OPT_STR, "comma-separated list of hosts [first=master]", \$HOSTS, ""],
    [ "v", "vservers", OPT_STR, "how many vservers per host", \$VSERVERS, "1"],
);

@ARGV = ProcessOptions (\@options, \@ARGV, -complain => 1);
if ($HOSTS eq "") { 
    tdie "Option -H, --hosts is compulsory. ";
}

my @hosts = split (/,/, $HOSTS);
for (my $i = 0; $i < @hosts; $i++) {
    my $host = $hosts [$i];
    my $blah = "928903849:23989384:2382839:93483924";  # some junk;
    my $login = $ENV{USERNAME} . "\@$host:$host";

    for (my $j = 0; $j < $VSERVERS; $j++) { 
	my $title;

	if ($j == 0 && $i == 0) { 
	    $title = "master ($host)";
	}
	else {
	    $title = "$host:$j";
	}
	print STDOUT sprintf ("%s\t'%s'\t%s\n", $login, $title, $blah);
    }
}
