#
# Run.pl configuration for Mercapp
#

use strict;
use Travertine;
use Options;
use vars qw($opt_timelim $opt_timeout $opt_size $opt_window $opt_proto $opt_config $opt_indiv);

###############################################################################

our @APP_INST_DIST = (
      "intel/defrag/build/ping*",
      "intel/defrag/*.so",
      "Merc/build/bootstrap",
      "Merc/configs/*.cfg",
      "Merc/configs/*.conf",		      
      "Merc/*.so",
      "Colyseus/*.so",
      "Colyseus/scripts/Topology2Waspnet.pl",
      "Data/topologies/emulab.*",
      "Colyseus/run/emulab/util",
);

our $APP_INST_PRE = sub {
    my $topdir = shift;
    my $username = shift;
    
    psystem("sudo mkdir -p $topdir");
    psystem("sudo chown $username $topdir");
};

our $APP_INST_POST = sub {

};

our $APP_DIR = "intel/defrag/build";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "pingserver";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = ".:..:../../../Merc:../../../Colyseus";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../../../Merc/build/bootstrap";

our $APP_TOPO2WASPNET = "../../../Colyseus/scripts/Topology2Waspnet.pl";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../../../Data/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = "../../../Merc/configs/schema_onehub.cfg";

our $APP_PARAMS_CONF = "../../../Merc/configs/params.conf";

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

###############################################################################

# application script parameters (passed to perl script)
our @APP_OPT_TABLE = 
(
 Options::String("#", "timelim", "execution time in secs", \$opt_timeout, "600"),
 Options::String("#", "proto", "{tcp,udp}", \$opt_proto, "udp"),
 Options::String("#", "size", "packet size in bytes (exclude header)", \$opt_size, "8"),
 Options::String("#", "window", "window size in pkts", \$opt_window, "8"),
 Options::String("#", "config", "send/recv config", \$opt_config, undef),
 Options::Boolean("#", "indiv", "send buffer per host", \$opt_indiv),
);

our $USE_SEND_MAP = 0;
our %ROLE_MAP = ();
our %SEND_MAP = ();

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers = shift;
    my @logins   = map { [ split(/\@|:/, $_) ] } @_;
    my $nservers = $vservers * scalar @logins;

    my @addrs;
    foreach my $login (@logins) {
	my $addr = $login->[2];
	for (my $i=0; $i<$vservers; $i++) {
	    my $port = 20000 + $i;
	    push @addrs, "$addr:$port";
	}
    }

    my $args =
	" --timeout $opt_timeout " .
	" --proto $opt_proto " .
	" --size $opt_size " .
	" --window $opt_window " .
	($opt_indiv ? " --indiv " : "");
    
    if ($opt_config) {
	$USE_SEND_MAP = 1;
	
	open(C, "<$opt_config") or tdie "can't open $opt_config";
	while (<C>) {
	    chomp;
	    next if /\s*\#/;
	    if (/([^ \t]+)\s+(\w)\s+([^ \t]+)/) {
		my ($src, $role, $dsts) = ($1, $2, $3);
		$SEND_MAP{$src} = $dsts;
		$ROLE_MAP{$src} = $role; 
	    } else {
		twarn "bad line in $opt_config: $_";
	    }
	}
	close(C);
    } else {
	$args .= " --hosts " . join(",", @addrs);
    }

    $APP_MASTER_ARGS = $APP_SLAVE_ARGS = $args;
};

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my ($login, $vindex, $port, $allref, $vservers) = @_;
    my ($user,$host,$iface) = split(/\@|:/, $login);
    
    my $p = 20000 + $vindex;
    my $args = " --ports $p ";

    if ($USE_SEND_MAP) {
	my $me = "$iface:$p";

	if ($SEND_MAP{$me}) {
	    $args .= " --hosts $SEND_MAP{$me} ";
	}
	if ($ROLE_MAP{$me} ne 's') {
	    $args .= " --nosend ";
	}
    }
    return $args;
};

1;
