#
# Run.pl configuration for Mercapp
#

use strict;
use Travertine;
use Options;
use vars qw($opt_p $opt_n);

###############################################################################
# The files to copy over to the remote host (relative to TOPDIR)
# (may be globs of files, but not of nested directories: ../*/*.. doesn't work)
# Do NOT include trailing slashes
#
our @APP_INST_DIST = (
      "Merc/build/bootstrap",
      "Merc/build/mercapp",
      "Merc/build/chkjoin2",
#     "Merc/build/rnet-test",
      "Merc/configs/params.conf",
      "Merc/configs/*.cfg",
      "Merc/*.so",
      "Colyseus/build/testgame",
      "Colyseus/*.so",
      "Data/rect_maps/*",
      "Data/topologies/*.lat",
      "Merc/util/time-test/client",
      "Merc/util/time-test/server",
	);

# Function to execute on remote host before sync
#
our $APP_INST_PRE = sub {
    my $topdir = shift;
    psystem("mkdir -p $topdir");
};

# Function to execute on the remote host after sync
#
our $APP_INST_POST = sub {
    my $topdir = shift;

    my %links = 
         ( "Merc/build/rect_maps" => "Data/rect_maps" );

    foreach my $from (keys %links) {
	psystem "rm -f $topdir/$from";
	psystem "ln -sf $topdir/$links{$from} $topdir/$from";
    }

    # chmod to correct permissions
    foreach my $dir ("Merc", "Colyseus", "Data") { 
        psystem("chmod -R g+rw $topdir/$dir >/dev/null 2>&1");
    }
};


# directory containing $APP_EXE in relation to $TOPDIR
our $APP_DIR = "Merc/build";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "mercapp";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = ".:..";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../../Data/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = "../configs/schema_onehub.cfg";

###############################################################################

our $aopt_spikes;
our $aopt_spike_height;
our %load_setup = ();

# application script parameters (passed to perl script)
our @APP_OPT_TABLE =
(
 Options::String("p", "npubs", "number of publications to send", \$opt_p, "100"),
 Options::String("n", "nsecs", "seconds for which each instance should run", \$opt_n, "150"),
 Options::String("#", "spikes", "number of spikes in the load", \$aopt_spikes, undef),
 Options::String("#", "spike-height", "height of each spike", \$aopt_spike_height, "1000")
);

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

sub rand_between($$) {
    return $_[0] + int(rand() * ($_[1] - $_[0]));
}

sub get_rand_permutation($$) {
    my $aref = shift;
    my $n = shift;

    foreach my $i (0 .. $n - 1) {
	$aref->[$i] = $i;
    }
    my ($tmp, $k);
    foreach my $i (0 .. $n - 2) {
	$k = rand_between($i + 1, $n);
	$tmp = $aref->[$k];
	$aref->[$k] = $aref->[$i];
	$aref->[$i] = $tmp;
    }
}

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers = shift;
    my @logins = @_;
    my $common_args = "";
    
    my $NPUBS = $opt_p;
    my $TIME  = $opt_n;
    my $tservers = $vservers * scalar @logins;
        
    $common_args = " --sampling --selfhistos --idletime " . ($tservers * 2);
    if (defined $NPUBS and $NPUBS > 0) { 
	$common_args .= " --npubs $NPUBS";
    }
    if (defined $TIME and $TIME > 0) {
	$common_args .= " --time $TIME";
    }

    $APP_MASTER_ARGS = $common_args;
    $APP_SLAVE_ARGS  = $common_args;

    if (defined $aopt_spikes) { 
	my @choices = ();
	get_rand_permutation(\@choices, scalar @logins * $vservers);

	my $nindex = 0;
	foreach my $login (@logins) {
	    foreach my $vin (0 .. $vservers - 1) {
		my $chosen = 0;
		foreach my $j (0 .. $aopt_spikes - 1) {
		    if ($choices[$j] == $nindex) {
			$chosen = 1;
			last;
		    }
		}
		if ($chosen) {
		    $load_setup{"$login:$vin"} = $aopt_spike_height;
		}
		else {
		    $load_setup{"$login:$vin"} = 100;
		}
		$nindex++;
	    }
	}
    }    
};

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my ($login, $vindex, $port, $allref, $vservers) = @_;
    
    if ($aopt_spikes) {
	tdie "load info not defined" if !exists $load_setup{"$login:$vindex"};
	return " --load-balance --load-balance-delta 2 --load " . $load_setup{"$login:$vindex"};
    }
    else {
	return "";
    }
};

1;
