#!/usr/bin/perl
#
# This script attaches the output of one or more hosts of an experiment 
# started with Run.pl to a gnome-terminal.
#

use strict;
use Travertine;
use Getopt::Std;
use IO::File;
use vars qw($opt_l $opt_t $opt_h $opt_A);

getopts("l:t:Ah");

if (!$ARGV[0] || $opt_h) {
    print STDERR "usage: Attach.pl [options] <exp_file>\n\n";
    print STDERR "       -l rex   only hosts with login matching regexp\n";
    print STDERR "       -t rex   only hosts with title matching regexp\n";
    print STDERR "       -A       skip aliveness check\n";
    print STDERR "       -h       this help message\n";
    exit 0;
}

our $INPUT = *STDIN;
our $LOGIN_REX = defined($opt_l) ? $opt_l : undef;
our $TITLE_REX = defined($opt_t) ? $opt_t : undef;
our $CHECKALIVE = !defined($opt_A);

if ($ARGV[0] ne '-') {
    $INPUT = new IO::File("<$ARGV[0]");
    tdie "can't open $ARGV[0]: $!" if !$INPUT;
}

our @triples;

our @titles;
our @refs;
while (<$INPUT>) {
    chomp $_;
    my ($login, $title, $ser) = ($_ =~ /^([^\t]+)\t'([^\t]+)'\t([^\t]+)$/);
    tdie "bad line: $_" if !defined $login or !defined $title or !$ser;

    next if ($LOGIN_REX && $login !~ $LOGIN_REX);
    next if ($TITLE_REX && $title !~ $TITLE_REX);

    my $ref = Travertine::RemoteDaemon::deserialize($ser);
    tdie "can't deserilize ref on line: $_" if !$ref;

    push @titles, $title;
    push @refs, $ref;
    push @triples, [ $login, $title, $ref ];
}

if (@refs == 0) {
    tdie "no matching logins/titles";
}

my @goodrefs;
my @goodtitles;

if ($CHECKALIVE) {
    # first check if they are alive...
    tinfo "** Checking whether all daemons are still alive...";
    
    our @ret = ParallelExec2(sub {
	my ($login, $title, $ref) = @_;
	return $ref->isAlive();
    }, @triples);

    for (my $i=0; $i<@ret; $i++) {
	if (!$ret[$i]) {
	    twarn "[ $triples[$i]->[0] => '$triples[$i]->[1]' ] is dead!";
	} else {
	    push @goodrefs, $refs[$i];
	    push @goodtitles, $titles[$i];
	}
    }
} else {
    @goodrefs = @refs;
    @goodtitles = @titles;
}


tinfo "** Launching gterm...";

# try to start all of 'em
# Travertine::RemoteDaemon::AttachToGterm(\@goodrefs, -titles => \@goodtitles);
Travertine::RemoteDaemon::attachToXterm($goodrefs[0], -title => $goodtitles[0]);
