#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw($opt_v $opt_t $opt_T);

getopts("v:t:T:");

our $LatStats = "~/Merc/scripts/TopologyLatStats.pl";

my $vservers = $opt_v || 3;
my $type = $opt_t || "med";

my $topo = $opt_T || "~/Merc/topologies/n100.v6.lat";

my @nodes = defined $ARGV[0] ? split(/,/,$ARGV[0]) : (5,10,20,30,40,50);

my @lats;

foreach my $n (@nodes) {
    print STDERR "getting lat stats for $n...\n";

    my $out = `$LatStats $topo $n $vservers`;
    die if !$out;
    $out =~ /$type=([\d\.]+)/;
    push @lats, $1;
}

print STDERR "$type: " . join(", ", @lats) . "\n";

map { $_ = $_/1000 } @lats;

for (my $i=0; $i<@lats; $i++) {
    print "$nodes[$i]\t$lats[$i]\n";
}
