#!/usr/bin/perl
#
# Server scaling plot.
#
# Usage: ServerScaling.pl [options] dat_dir data_points > output
#
# option:
#
# -p postfix  one of {MEAN, 95%, 99%}
#
###############################################################################

use strict;
use Getopt::Std;
use vars qw($opt_p $opt_g);

getopts ("p:g:");

my $dir = $ARGV[0] || ".";
my @nodes = defined $ARGV[1] ? split(/,/, $ARGV[1]) : (20, 40, 50, 80, 100);
our @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());
my $datafile = "nodes"; 

my $orig = `pwd`; chomp $orig;
chdir $dir;

# get data for merc --- grep TOTAL:OUT
my @total = `grep TOTAL:OUT:MEAN nodes | awk '{ print \$2, \$3 }'`; chomp (@total);
my @total95 = `grep TOTAL:OUT:95% nodes | awk '{ print \$2 }'`; chomp (@total95);

my @routes = `grep ROUTE:OUT:MEAN nodes | awk '{ print \$2 }'`; chomp (@routes);
my @re = `grep ROUTE:OUT:MEAN nodes | awk '{ print \$3 }'`; chomp (@re);
my @oms = `grep OM:OUT:MEAN nodes | awk '{ print \$2 }'`; chomp (@oms);
my @oe = `grep OM:OUT:MEAN nodes | awk '{ print \$3 }'`; chomp (@oe);
my @matchs = `grep MATCH:OUT:MEAN nodes | awk '{ print \$2 }'`; chomp (@matchs);
my @me = `grep MATCH:OUT:MEAN nodes | awk '{ print \$3 }'`; chomp (@me);

my @routes95 = `grep ROUTE:OUT:95% nodes | awk '{ print \$2 }'`; chomp (@routes95);
my @re95 = `grep ROUTE:OUT:95% nodes | awk '{ print \$3 }'`; chomp (@re95);
my @oms95 = `grep OM:OUT:95% nodes | awk '{ print \$2 }'`; chomp (@oms95);
my @oe95 = `grep OM:OUT:95% nodes | awk '{ print \$3 }'`; chomp (@oe95);
my @matchs95 = `grep MATCH:OUT:95% nodes | awk '{ print \$2 }'`; chomp (@matchs95);
my @me95 = `grep MATCH:OUT:95% nodes | awk '{ print \$3 }'`; chomp (@me95);

open F, ">/tmp/dat";
foreach my $i (0..$#nodes) {
	print F "$nodes[$i] $routes[$i] $routes[$i] $routes95[$i] $re[$i]\n";
}
print F "\n\n";
foreach my $i (0..$#nodes) {
    my $mean = ($routes[$i] + $matchs[$i]);
    my $std = $re[$i] + $me[$i]; # XXX this isn't really right...
    my $ninefive = ($routes95[$i] + $matchs95[$i]);
    print F "$nodes[$i] $mean $mean $ninefive $std\n";
}
print F "\n\n";
foreach my $i (0..$#nodes) {
    my ($mean, $std) = split(/\s+/, $total[$i]);
    my $ninefive = $total95[$i];
    print F "$nodes[$i] $mean $mean $ninefive $std\n";
}
close F;

my $min_x = 0;
my $max_x = $nodes[$#nodes] + 10;
chdir $orig;

my $gpl = <<EOT;
set terminal postscript 
set xlabel "Number of servers"
set ylabel "Per-node outgoing bandwidth (kbps)"
set key top right
set border 31 lw 1.4
# set size 0.8,0.8
set grid ytics lw 2 
set xrange [$min_x:$max_x]
# set yrange [:600]

EOT

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

my $index = 2;
$gpl .= " plot "; 
foreach my $s ([ "routing+matching+updates", 1, 5 ],
	       [ "routing+matching", 2, 7 ],
	       [ "routing", 4, 9 ])
{
    my ($title, $lt, $pt) = @$s;
    $gpl .= " '/tmp/dat' index $index title '$title' w lp lw 2.5 ps 1 lt $lt pt $pt,";
    $gpl .= " '/tmp/dat' index $index notitle w yerrorbars lw 1.5 ps 1 lt $lt pt $pt,";
    $gpl .= " '/tmp/dat' index $index using 1:2:2:(\$2+\$5) notitle w yerrorbars lw 5 ps 1 lt $lt pt $pt";
    if ($index != 0) {
	$gpl .= ", ";	
    }
    $index--;
}

open G, "| gnuplot";
print G $gpl;
close G;
