#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw($opt_t $opt_g $opt_T);

getopts("t:g:T:");

my @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());
my $type = $opt_t || "MEDIAN";
our $TITLE = defined $opt_T ? $opt_T : "Latency graph";

my $file    = $ARGV[0];
my $latfile = $ARGV[1];
my $ninefivelatfile = $ARGV[2];
my @nodes = defined $ARGV[3] ? split(/,/,$ARGV[3]) : (5,10,20,30,40,50);

my @median = `grep $type $file | awk '{ print \$11 }'`; 
chomp (@median);

my @median_merc = `grep $type $file | awk '{ print \$2, \$3, "-"\$10 }'`; 
chomp (@median_merc);

my @median_match = `grep $type $file | awk '{ print \$4 }'`;
chomp (@median_match);

my @median_fetch = `grep $type $file | awk '{ print \$6, \$8 }'`; 
chomp (@median_fetch);

#my @median_nocpu = `grep $type $file | awk '{ print \$4, \$5, \$6, \$8, \$10, \$12 }'`; chomp (@median_nocpu);

my @ninefive = `grep '95 %' $file | awk '{ print \$14 }'`; chomp (@ninefive);
die "bad file: $file" if !@median || !@ninefive;

calc(\@median_merc);
calc(\@median_match);
calc(\@median_fetch);

sub calc {
    my $ref = shift;

    foreach my $tuple (@$ref) {
	my @vals = split(/\s+/, $tuple);
	$tuple = 0;
	foreach my $v (@vals) {
	    $tuple += $v;
	}
    }
}

#my @medlats;
#my @ninefivelats;
#
#getLats(\@medlats, $latfile);
#getLats(\@ninefivelats, $ninefivelatfile);
#
#sub getLats {
#    my $ref = shift;
#    my $file = shift;
#
#    open(L, "<$file") || die "bad latfile: $file";
#    while (<L>) {
#	chomp $_;
#	if ($_ =~ /^\d+\t(.*)/) {
#	    push @$ref, $1;
#	}
#    }
#    close (L);
#}

###############################################################################

open F, ">/tmp/dat";
foreach my $i (0..$#nodes) {
    print F (($nodes[$i]) . "\t$median[$i] $ninefive[$i]\n");
}
#print F "\n\n";
#foreach my $i (0..$#nodes) {
#	print F (($nodes[$i]*$vservers) . "\t$ninefive[$i]\n");
#}
print F "\n\n";
foreach my $i (0..$#nodes) {
    print F (($nodes[$i]) . "\t" . ($median_match[$i]+$median_merc[$i]+$median_fetch[$i]) . "\n");
}
print F "\n\n";
foreach my $i (0..$#nodes) {
    print F (($nodes[$i]) . "\t" . ($median_match[$i]+$median_merc[$i]) . "\n");
}
print F "\n\n";
foreach my $i (0..$#nodes) {
    print F (($nodes[$i]) . "\t$median_merc[$i]\n");
}

#foreach my $i (0..$#nodes) {
#    print F (($nodes[$i]) . "\t$medlats[$i] $ninefivelats[$i]\n");
#}
#print F "\n\n";
#foreach my $i (0..$#nodes) {
#	print F (($nodes[$i]*$vservers) . "\t$ninefivelats[$i]\n");
#}
close F;

my $gpl = <<EOT;
set terminal postscript 
set xlabel "Number of nodes"
set ylabel "Median object discovery time (sec)"
set key top left #outside below Left reverse
set title "$TITLE"
# set size 0.8,0.8
set border 31 lw 1.4
set grid ytics lw 2 
# set yrange [:0.7]
EOT

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

$gpl .= <<EOT;

plot \\
    '/tmp/dat' index 0 title 'total' w lp lw 2.5 ps 1 pt 5 lt 1, \\
    '/tmp/dat' index 0 using 1:2:2:3 notitle w yerrorbars lw 1.5 ps 1 pt 5 lt 1, \\
    '/tmp/dat' index 1 title 'routing+matching+fetching' w lp lw 2.5 ps 1 pt 7 lt 2, \\
    '/tmp/dat' index 2 title 'routing+matching' w lp lw 2.5 ps 1 pt 9 lt 3, \\
    '/tmp/dat' index 3 title 'routing' w lp lw 2.5 ps 1 pt 13 lt 4
EOT

$gpl .= "  ";
open G, "| gnuplot";
print G $gpl;
close G;
