#!/usr/bin/perl
#
# Usage: FrameRates.pl [options] dat_dir data_points > output
#  -g stuff     [add stuff to gnuplot plot setup]
# 
###############################################################################

use strict;
use Getopt::Std;
use vars qw($opt_g);

getopts ("g:");

my $dir = $ARGV[0] || ".";
my @nodes = defined $ARGV[1] ? split(/,/, $ARGV[1]) : (20, 40, 50, 80, 100);
our @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());
my $datafile = "nodes"; 

my $orig = `pwd`; chomp $orig;
chdir $dir;

# get data for merc --- grep TOTAL:OUT
my @fs = `grep MEAN nodes | awk '{ print \$2, \$3 }'`; chomp (@fs);

open F, ">/tmp/dat";
foreach my $i (0..$#nodes) {
	print F "$nodes[$i] $fs[$i]\n";
}
print F "\n\n";
close F;

my $min_x = 0;
my $max_x = $nodes[$#nodes] + 10;
chdir $orig;

my $gpl = <<EOT;
set terminal postscript 
set xlabel "Number of servers"
set ylabel "Framerates"
set key top right
set border 31 lw 1.4
# set size 0.8,0.8
set grid ytics lw 2 
set xrange [$min_x:$max_x]
set yrange [0:150]

EOT

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

my $index = 0;
$gpl .= " plot "; 
foreach my $s ([ "Mean", 3], [ "Median", 2])
{
    my ($title, $field) = @$s;
    
    $gpl .= " '/tmp/dat' using 1:$field title '$title' w lp lw 2.5 ps 1";
    if ($index == 0) {
	$gpl .= ", ";	
    }
    $index++;
}

open G, "| gnuplot";
print G $gpl;
close G;
