#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw($opt_s);

# -s skip points
getopts("s:");

my %SKIP = defined $opt_s ? map { $_ => 1 } split(/,/, $opt_s) : ();

my $fudge0 = $ARGV[0];
my $fudge1 = $ARGV[1];
my $fudge4 = $ARGV[2];

my @nodes = defined $ARGV[3] ? split(/,/, $ARGV[3]) : (5,10,20,30,40,50);
my $vservers = 1;

my @reg_mean = `grep MEAN $fudge0 | awk '{ print \$2 }'`; chomp (@reg_mean);
my @reg_ninefive = `grep '95%' $fudge0 | awk '{ print \$2 }'`; chomp (@reg_ninefive);

my @fudge1_mean = `grep MEAN $fudge1 | awk '{ print \$2 }'`; chomp (@fudge1_mean);
my @fudge1_ninefive = `grep '95%' $fudge1 | awk '{ print \$2 }'`; chomp (@fudge1_ninefive);

my @fudge4_mean = `grep MEAN $fudge4 | awk '{ print \$2 }'`; chomp (@fudge4_mean);
my @fudge4_ninefive = `grep '95%' $fudge4 | awk '{ print \$2 }'`; chomp (@fudge4_ninefive);

open F, ">/tmp/dat";
foreach my $i (0..$#nodes) {
    next if $SKIP{$nodes[$i]*$vservers};
    print F (($nodes[$i]*$vservers) . "\t$reg_mean[$i]\n");
}
print F "\n\n";
foreach my $i (0..$#nodes) {
    next if $SKIP{$nodes[$i]*$vservers};
    print F (($nodes[$i]*$vservers) . "\t$fudge1_mean[$i]\n");
}
print F "\n\n";
foreach my $i (0..$#nodes) {
    next if $SKIP{$nodes[$i]*$vservers};
    print F (($nodes[$i]*$vservers) . "\t$fudge4_mean[$i]\n");
}
close F;

my $gpl = <<EOT;
set terminal postscript eps 20
set xlabel "Number of nodes"
set ylabel "Avg. frac mobile objects missing"
set key top left Left reverse
set size 0.8,0.8
set border 31 lw 1.4
set grid ytics lw 2 

plot \\
    '/tmp/dat' index 0 title 'no delay' w lp lw 2.5 ps 1 pt 5 lt 1, \\
    '/tmp/dat' index 1 title '100ms delay' w lp lw 2.5 ps 1 pt 7 lt 2, \\
    '/tmp/dat' index 2 title '400ms delay' w lp lw 2.5 ps 1 pt 6 lt 3
EOT

$gpl .= "  ";
open G, "| gnuplot";
print G $gpl;
close G;

