#!/usr/bin/perl

use strict;
use lib "$ENV{HOME}/Merc/scripts";
use ResultsConf;
use Getopt::Std;
use vars qw($opt_e $opt_g $opt_n $opt_C);

getopts("e:g:n:C");

my $NODENAME = $opt_n || "X";
my $COLYSEUS_ONLY = $opt_C;

my $EPOCH = $opt_e || 1;
my @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());

die "need 5 args" if @ARGV < 5;

my $COLYSEUS_TOTAL    = $ARGV[0];
my $COLYSEUS_MERC = $ARGV[1];
my $COLYSEUS_ROUTING  = $ARGV[2];

my $CLIENT_SERVER = $ARGV[3];
my $BROADCAST     = $ARGV[4];

my $start = `~/Merc/scripts/MaxStartTime.pl -M $COLYSEUS_TOTAL $COLYSEUS_ROUTING $COLYSEUS_MERC $CLIENT_SERVER $BROADCAST`;
chomp $start;

$start = $start-$SKIPTIME;

my $index = 1; 
foreach my $l ($COLYSEUS_TOTAL, $COLYSEUS_MERC, $COLYSEUS_ROUTING) 
{
    # filter out timevals that are more than 3 stddevs below the mean
    # (every 60 seconds the bwidth drops to 0 due to loggin)
    system("~/Merc/scripts/TimeSeriesAvg.pl -F 3 -M 1 -e $EPOCH $l | ~/Merc/scripts/TimeFilter.pl -r -S $start -s 0 -l 9999999999 > /tmp/$index.dat");
    $index++;
}

if (!$COLYSEUS_ONLY) {
foreach my $l ($CLIENT_SERVER, $BROADCAST) 
{
    # filter out timevals that are more than 3 stddevs below the mean
    # (every 60 seconds the bwidth drops to 0 due to loggin)
    system("~/Merc/scripts/TimeSeriesAvg.pl -F 3 -M 1 -C -e $EPOCH $l | ~/Merc/scripts/TimeFilter.pl -r -S $start -s 0 -l 9999999999 > /tmp/$index.dat");
    $index++;
}
}

my $gpl = <<EOT;
set terminal postscript eps 20
set xlabel "Time (sec)"
set ylabel "Outgoing bandwidth (kbps)"
set key outside below Left reverse
set size 0.8,0.8
set border 31 lw 1.4
set grid ytics lw 2
set autoscale xfix
set yrange [0:]
EOT

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

$gpl .= "plot ";
if (!$COLYSEUS_ONLY) {
    $gpl .= <<EOT;
    '/tmp/4.dat' title 'single-server' w lines lw 2 lt 2, \\
    '/tmp/5.dat' title 'broadcast' w lines lw 2 lt 3, \\
    '/tmp/1.dat' title 'colyseus' w lines lw 2 lt 1
EOT
} else {
    $gpl .= <<EOT;
    '/tmp/1.dat' title 'routing+matching+updates' w lines lw 2 lt 1, \\
    '/tmp/2.dat' title 'routing+matching' w lines lw 2 lt 4, \\
    '/tmp/3.dat' title 'routing' w lines lw 2 lt 5
EOT
}

$gpl .= "  ";
open G, "| gnuplot";
print G $gpl;
close G;
