////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef __TEST_LOGS_H__
#define __TEST_LOGS_H__

#include <util/IPEndPoint.h>
#include <util/ID.h>
#include <util/types.h>
#include <util/ExpLog.h>

#define ENABLE_COSTESTIMATEACCURACYLOG 0
#define ENABLE_LOADESTIMATEACCURACYLOG 1

// log for testing accuracy of object delta cost estimates
struct CostEstimateAccuracyEntry : public ExpLogEntry
{
    GUID guid;
    float estimate;
    float actual;

    uint32 Dump(FILE *fp) {
	uint32 ret = _PrintTime (fp, time);
	ret += _PrintGUID (fp, guid);

	ret += fprintf(fp, "\t%f\t%f\n", 
		estimate, actual);
	return ret;
    }
};

// log for testing accuracy of load prediction
struct LoadEstimateAccuracyEntry : public ExpLogEntry
{
    // normalized values (to capacity)
    float localLoad;
    float localLoadActual;
    float localTarget;
    float localMargin;
    float systemLoadMean;
    float systemLoadStdDev;

    uint32 Dump(FILE *fp) {
	return fprintf(fp, "%13.3f\t%f\t%f\t%f\t%f\t%f\t%f\n", 
		(double)time.tv_sec + 
		(double)time.tv_usec/USEC_IN_SEC,
		localLoad, localLoadActual, localTarget, localMargin, 
		systemLoadMean, systemLoadStdDev);
    }
};

DECLARE_EXPLOG(CostEstimateAccuracyLog, CostEstimateAccuracyEntry);
DECLARE_EXPLOG(LoadEstimateAccuracyLog, LoadEstimateAccuracyEntry);

extern void InitOMTestLogs(SID);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
