////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
#ifndef __OMPUBSUBSTORE__H
#define __OMPUBSUBSTORE__H   

#include <list>
#include <map>
#include <mercury/Event.h>
#include <mercury/Interest.h>
#include <util/RTree.h>
#include <mercury/Application.h>

class Interest;
class MemberHub;

struct EvWrapper {
    MsgPublication *pmsg;

    EvWrapper (MsgPublication *pmsg) : pmsg (pmsg) {}
    void GetExtent (Rect<Value> *extent);    
};

struct InWrapper {
    Interest *in;

    InWrapper (Interest *in) : in (in) {}    
    void GetExtent (Rect<Value> *extent);
};


/**
 * Stores the publications and subscriptions in Mercury. 
 * Default mercury implementation
 **/
class OMPubsubStore : public PubsubStore {
    struct less_Event {
	bool operator() (const Event *a, const Event *b) const {
	    return a->LessThan(b);
	}
    };

    typedef map<Event *, EvWrapper *, less_Event> PubMsgMap;
    typedef PubMsgMap::iterator PubMsgMapIter;

    typedef list<InWrapper *> IntLst;
    typedef IntLst::iterator  IntLstIter;
 private:
    PubMsgMap            m_TriggerMap;
    IntLst               m_SubList;

    RTree<EvWrapper, Value> m_PubTree;
    RTree<InWrapper, Value> m_SubTree;    
 public:
    OMPubsubStore ();
    virtual ~OMPubsubStore () {}

    void StoreTrigger (MsgPublication *pmsg);
    void StoreSub (Interest *in);

    void DeleteTriggers (callback<bool, MsgPublication *>::ref delpred) {
	for (PubMsgMapIter it = m_TriggerMap.begin (); it != m_TriggerMap.end (); /* ++it */) {
	    if (delpred (it->second->pmsg)) {
		_DeletePub (it);
	    }
	    else {
		++it;
	    }
	}
    }
    void DeleteSubs (callback<bool, Interest *>::ref delpred) {
	for (IntLstIter it = m_SubList.begin (); it != m_SubList.end (); /* ++it */)
	{
	    if (delpred ((*it)->in)) {
		it = _DeleteSub (it);
	    }
	    else {
		++it;
	    }
	}			
    }

    void GetOverlapSubs (MsgPublication *pmsg, list<Interest *> *pmatch);
    void GetOverlapTriggers (Interest *in, list<MsgPublication *> *pmatch);

    void Clear ();   
 private:
    void _DeletePub (PubMsgMapIter& giter);
    IntLstIter _DeleteSub (IntLstIter& iter);
    void _InsertPub (MsgPublication *pmsg);
    void _InsertSub (Interest *in);
};

#endif /* __OMPUBSUBSTORE__H */
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
