////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
#ifndef __OMINTEREST__H
#define __OMINTEREST__H

#include "common.h"
#include <mercury/Interest.h>
#include <util/TimedStruct.h>

extern InterestType INTEREST_OM;
void OM_RegisterInterestTypes ();

class OMInterest : public Interest, public TimedStruct {

    Tags       m_Tags;     // "tags" that will be placed in matched pubs    
 protected:
    DECLARE_TYPE (Interest, OMInterest);

 public:	
    OMInterest(void);
    OMInterest(guid_t g); 
    OMInterest(Packet *pkt);
    virtual ~OMInterest() {}

    /*
      const Constraint *GetConstraint(int i) {
      return GetConstraintByAttr(i);
      }
    */

    void SetLifeTime(uint32 t) {
	Interest::SetLifeTime(t);
	TimedStruct::SetLifeTime(t);
    }

    void  AddTag(GUID tag) { m_Tags.insert(tag); }
    Tags& GetTags() { return m_Tags; }

    virtual ostream& Print (ostream& os) const;

    /////////////////////////////////////////////////////////////////
    //  Serialization
    virtual void   Serialize(Packet *pkt);
    virtual uint32 GetLength();
    virtual void   Print(FILE *stream);    
};

#endif // __OMINTEREST__H
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
