////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
#include <om/OMInterest.h>
#include <om/OMLoadManager.h>

InterestType INTEREST_OM;

void OM_RegisterInterestTypes () {
    INTEREST_OM = REGISTER_TYPE (Interest, OMInterest);
    INTEREST_OM_LOAD = REGISTER_TYPE (Interest, OMLoadInterest);
}

OMInterest::OMInterest() :
    Interest(SID_NONE /* XXX WTF DO I PUT HERE? */, GUID_NONE), TimedStruct((uint32)0)
{
}

OMInterest::OMInterest(guid_t g) :
    Interest(SID_NONE /* XXX WTF DO I PUT HERE? */, g), TimedStruct((uint32)0)
{
}

OMInterest::OMInterest(Packet * pkt) :
    Interest(pkt), TimedStruct((uint32)0)
{
    uint32 numTags = pkt->ReadInt();
    for (uint32 i = 0; i < numTags; i++) {
	GUID tag(pkt);
	m_Tags.insert(tag);
    }
}

void OMInterest::Serialize(Packet * pkt)
{
    Interest::Serialize(pkt);

    uint32 numTags = m_Tags.size();
    pkt->WriteInt(numTags);
    for (Tags::iterator it = m_Tags.begin(); it != m_Tags.end(); it++) {
	GUID guid = *it;
	guid.Serialize(pkt);
    }
}

uint32 OMInterest::GetLength()
{
    uint32 length = Interest::GetLength();

    length += 4;     // numTags
    for (Tags::iterator it = m_Tags.begin(); it != m_Tags.end(); it++) {
	GUID guid = *it;
	length += guid.GetLength();
    }

    return length;
}

void OMInterest::Print(FILE * stream) 
{
    Interest::Print(stream);
}

ostream& OMInterest::Print (ostream& out) const
{
    //Interest::Print (out);

    // XXX Needed for backwards compat with om regression tests :P
    out << "Interest guid=" << GetGUID() << " subscriber=[" << GetSubscriber() << "] cons=[";

    for (Interest::iterator it = begin (); it != end (); it++) {
	if (it != begin ()) out << ",";
	Constraint *c = *it;
	out << G_GetTypeName (c->GetAttrIndex()) << ":>=:int:" << c->GetMin()
	    << "," << G_GetTypeName (c->GetAttrIndex()) << ":<=:int:"
	    << c->GetMax();
    }
    out << "] lifetime=" << GetLifeTime() << " deathtime=" << GetDeathTime();

    OMInterest *sub = (OMInterest *) this;
    out << " tags=[";
    Tags tags = sub->GetTags();
    for (Tags::iterator it = tags.begin(); it != tags.end(); it++) {
	if (it != tags.begin()) out << ",";
	out << *it;
    }
    out << "]";
    return out;
}

// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
