////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#include <om/GObject.h>
#include <om/Manager.h>
    
///////////////////////////////////////////////////////////////////////////////

GObject::GObject(guid_t guid) : m_Deleted(false)
{
    Manager *m = Manager::GetInstance();
    m_Info = m->AllocGObjectInfo(guid, m->GetSID(), false);
    ((GObjectInfo *)m_Info)->SetObject( this );
}

GObject::~GObject() 
{
    Manager *m = Manager::GetInstance();
    m->FreeGObjectInfo( (GObjectInfo *)m_Info, true );
}

void GObject::Delete()
{
    Manager *m = Manager::GetInstance();
    ASSERT( m->GetObjectStore()->Find(GetGUID()) == NULL );
    ASSERT( m->GetPendingStore()->Find(GetGUID()) == NULL );

    m->FreeGObjectInfo( (GObjectInfo *)m_Info, false /* don't dealloc yet */);
    m_Deleted = true;
}

bool GObject::IsDeleted() 
{ 
    return m_Deleted; 
}

GObject::GObject(GObjectInfoIface *info) : m_Deleted(false)
{
    ASSERT(info != NULL);

    m_Info = info;
    ASSERT( ((GObjectInfo *)m_Info)->GetObject() == NULL);
    ((GObjectInfo *)m_Info)->SetObject( this );
}

ostream& operator<<(ostream& out, GObject *objp)
{
    out << "(GObject guid=" << objp->GetGUID() 
	<< " sid="    << objp->GetSID() 
	<< " status=" << (objp->IsReplica()?"R":"P")
	<< " mask="   << objp->GetDeltaMask() << " ";
    objp->PrintFields(out);
    out << ")";
    return out;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
