////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:C++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __GINTEREST__H
#define __GINTEREST__H

#include <om/common.h>

struct GInterest : public Serializable {
    GUID guid;           // guid we are interested in
    bool newRegister;    // true if we need a new copy of the object
    bool unregister;     // true if we are no longer interested in guid
    uint16 numInterests; // number of objects interested in guid (< 16384)

    ///// MEASUREMENT VARIABLES (see ObjectLogs.h)
    uint32 nonce;
    TimeVal recvTime; // NOT serialized (HACK: set from reg msg)
    /////

    GInterest();
    GInterest(GUID guid, uint16 numInterests);
    virtual ~GInterest();

    GInterest(Packet *pkt);
    void Serialize(Packet *pkt);
    uint32  GetLength();
    void Print(FILE *stream);
    void Print(ostream& os);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
