////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:C++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#include <om/GInterest.h>
#include <mercury/ObjectLogs.h>

GInterest::GInterest() : guid(GUID_NONE), newRegister(false),
    unregister(false), numInterests(0) 
{
    OBJECT_LOG_DO( nonce = 0 );
}

GInterest::GInterest(GUID guid, uint16 numInterests) : 
    guid(guid), numInterests(numInterests), 
    newRegister(false), unregister(false) 
{
    OBJECT_LOG_DO( nonce = 0 );
}

GInterest::~GInterest() {}

GInterest::GInterest(Packet *pkt) { 
    guid = GUID(pkt);
    uint16 val   = pkt->ReadShort();
    newRegister  = val & 16384;
    unregister   = val & 32768;
    numInterests = val & ~(32768 | 16384);

    OBJECT_LOG_DO( nonce = pkt->ReadInt() );
}

void GInterest::Serialize(Packet *pkt) {
    guid.Serialize(pkt);
    ASSERT(numInterests < 16384);
    uint16 val = numInterests;
    if (newRegister)
	val |= 16384;
    if (unregister)
	val |= 32768;
    pkt->WriteShort(val);

    OBJECT_LOG_DO( pkt->WriteInt(nonce) );
}

uint32  GInterest::GetLength() {
    uint32 length = guid.GetLength() + 2;

    OBJECT_LOG_DO( length += 4 );

    return length;
}

void GInterest::Print(FILE *stream) {
    ASSERT(false);
}

void GInterest::Print(ostream& os) {
    os << "(GInterest " << guid << " newReg=" << newRegister
	<< " unreg=" << unregister
	<< " numIn=" << numInterests << ")";
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
