////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  DeltaInfo.cpp

begin           : Nov 6, 2002
copyright       : (C) 2002-2004 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2003-2004 Jeff Pang      ( jeffpang@cs.cmu.edu   )

***************************************************************************/

#include <om/DeltaInfo.h>
#include <mercury/ObjectLogs.h>

    DeltaInfo::DeltaInfo() : 
	TimedStruct(ManagerParams::REPLICA_MAINTAIN_TTL),
	mask(DELTA_MASK_NONE), isNew(true), isDelete(false), isProactive(false)
{
    OBJECT_LOG_DO( nonce = 0 );
};

DeltaInfo::~DeltaInfo() {}

// We could transfer the soft-state timer over the wire also
// but that would require that we have synchronized timers
// for it to be correct, so instead just optimistically assume
// that we reset the timer when it is deserialized
DeltaInfo::DeltaInfo(Packet *pkt) : 
    TimedStruct(ManagerParams::REPLICA_MAINTAIN_TTL)
{
    mask = DeltaMask(pkt);
    byte flags = pkt->ReadByte();
    isNew    = flags & 1;
    isDelete = flags & 2;
    isProactive = flags & 4;

    OBJECT_LOG_DO( nonce = pkt->ReadInt() );
}

void DeltaInfo::Serialize(Packet *pkt)
{
    mask.Serialize(pkt);
    byte flags = 0;
    if (isNew)
	flags |= 1;
    if (isDelete)
	flags |= 2;
    if (isProactive)
	flags |= 4;
    pkt->WriteByte(flags);

    OBJECT_LOG_DO( pkt->WriteInt(nonce) );
}

uint32 DeltaInfo::GetLength()
{
    uint32 length = mask.GetLength() + 1;

    OBJECT_LOG_DO( length += 4 );

    return length;
}

ostream& operator<<(ostream& out, DeltaInfo *info)
{
    out << "(isNew=" << info->isNew << " isDelete=" << info->isDelete
	<< " isProactive=" << info->isProactive 
	<< " mask=" << info->mask << ")";
    return out;
}

// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
