////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  GameManager.h

  Top-level interface to the game application.

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __GAME_VISUALIZER_H__
#define __GAME_VISUALIZER_H__

#include <map>

static const uint16 VISUALIZER_PORT = 60000;
static const uint32 UDP_MAXLEN = 1472;

#define MSGTYPE_ENTITIES  0
#define MSGTYPE_WAYPOINTS 1
#define MSGTYPE_INTGRAPH  2

#define STATUS_PRIMARY    0x0
#define STATUS_REPLICA    0x1

typedef enum {
    VisType_Missile = 0x1 << 1,
    VisType_Player = 0x1 << 2,
    VisType_Bot = 0x1 << 3,
    VisType_Item = 0x1 << 4,
    VisType_Other = 0x1 << 5
} VisType;

#if 0
#define CLASSNAME_MISSILE (0x1 << 1)
#define CLASSNAME_BOT     (0x1 << 2)
#define CLASSNAME_ITEM    (0x1 << 3)
#define CLASSNAME_OTHER   (0x1 << 4)
#endif

struct VizInterestLink
{
    float from[2];
    float to[2];
    byte stable;
};

// MSG_TYPE_ENTITIES:
//
// msg_type + frameno + entities...
//
// status/classname byte + 
// origin[0-2] + bbox min,max + pred bbox min,max
static const uint32 EDICT_DUMP_SIZE = 1 + 12 + 2*12 + 2*12;

// MSG_TYPE_WAYPOINTS:
//
// msg_type + frameno + node_count + node_vecs... + edge_count + (vec1,vec2)...

// MSG_TYPE_INTGRAPH
//
// msg_type + frameno + VizInteretLink...
static const uint32 LINK_DUMP_SIZE = 2*4 + 2*4 + 1;

// HACK: visualiser client doesn't want this stuff
#ifndef NO_COLYSEUS_INCLUDE

#include <gameapi/common.h>
#include <util/GPL/callback.h>

class GameVisualizer {
    struct sockaddr_in m_VisAddr;
    int m_UpdateRate;
    TimeVal m_LastSent;

 public:
    GameVisualizer() : m_UpdateRate (10), m_LastSent (TIME_NONE) { 
	bzero(&m_VisAddr, sizeof(m_VisAddr)); 
    }

    void SendEdicts (callback<bool>::ref cb);
    void SendInterests (callback<bool>::ref cb);

    void SendTCPUpdate (ostream& out);

    bool SetTargetIP(const char *ipaddr);
    bool SetUpdateRate (int rate);
    void SendUpdates();
};

#endif

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
