////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  GameStore.h

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __GAME_STORE_H__
#define __GAME_STORE_H__

#include <gameapi/common.h>
#include <util/ID.h>
#include <om/GameAdaptor.h>

class GameObject;
class StaticGameObject;
class DynamicGameObject;
class GameWorld;
class GameManager;

typedef map<GUID, DynamicGameObject *, less_GUID> DynamicObjMap;
typedef DynamicObjMap::iterator DynamicObjMapIter;
typedef map<GUID, StaticGameObject *, less_GUID> StaticObjMap;
typedef StaticObjMap::iterator StaticObjMapIter;

typedef list<DynamicGameObject *> DynamicObjList;
typedef DynamicObjList::iterator DynamicObjListIter;
typedef list<StaticGameObject *> StaticObjList;
typedef StaticObjList::iterator StaticObjListIter;

class DynamicObjectStore : public ObjectStore {
    friend class GameManager;
 private:
    GameWorld *m_World;
    bool m_LinkOnManagerAdd; // link with world on manager add
    DynamicObjMap m_Store;

    DynamicObjList m_Iter;
    DynamicObjListIter m_Curr;
 public:
    DynamicObjectStore(GameWorld *world, bool link) : 
	m_World(world), m_LinkOnManagerAdd(link) {}
    virtual ~DynamicObjectStore() {}

    // XXX - at some point go back and make all these iterators
    // somewhat more thread-safe... at least should be read-only thread-safe
    void Begin();
    GObject *Next();
    uint32 Size();

    GObject *Find(guid_t guid);
    void _ManagerAdd(GObject *obj);
    void _ManagerRemove(guid_t guid);

 protected:
    void _ApplicationAdd(GObject *obj);
    void _ApplicationRemove(guid_t guid);
};

///////////////////////////////////////////////////////////////////////////////

class GameStore {
 private:
    friend class GameManager;
    friend class GameObjectRef;
    friend class GameObject;

    static GameStore *m_Instance;

    GameWorld *m_World;
    DynamicObjectStore *m_DynamicStore;
    DynamicObjectStore *m_DynamicPending;
    StaticObjMap m_StaticStore;

    StaticObjList m_StaticIter;
    StaticObjListIter m_StaticCurr;

    GameStore(GameWorld *world);

 public:
    static GameStore *GetInstance(GameWorld *world);
    static GameStore *GetInstance();

    virtual ~GameStore();

    GameObject *Find(GUID guid);
    void Add(GameObject *obj);
    GameObject *Remove(GUID guid);
    uint32 Size();

    // XXX - at some point go back and make all these iterators
    // somewhat more thread-safe... at least should be read-only thread-safe
    void Begin();
    GameObject *Next();

    void BeginDynamic();
    DynamicGameObject *NextDynamic();
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
