////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#include <om/Manager.h>
#include "GameLogs.h"

IMPLEMENT_EXPLOG(QuakeStatsLog, QuakeStatsLogEntry);
IMPLEMENT_EXPLOG(DGStoreLog, DGStoreLogEntry);
IMPLEMENT_EXPLOG(ObjectInterestLog, ObjectInterestEntry);
IMPLEMENT_EXPLOG(ObjectDeltaLog, ObjectDeltaEntry);
IMPLEMENT_EXPLOG(GUIDLog, GUIDLogEntry);
IMPLEMENT_EXPLOG(ClientLog, ClientLogEntry);
IMPLEMENT_EXPLOG(PositionLog, PositionEntry);

void InitGameLogs(SID& sid)
{
    ASSERT(g_MeasurementParams.enabled);

    if (!g_QuakeStatsLog)
	INIT_EXPLOG(QuakeStatsLog, sid);
    if (!g_DGStoreLog)
	INIT_EXPLOG(DGStoreLog, sid);
    if (!g_ObjectDeltaLog)
	INIT_EXPLOG(ObjectDeltaLog, sid);
    if (!g_ObjectInterestLog)
	INIT_EXPLOG(ObjectInterestLog, sid);
    if (!g_GUIDLog)
	INIT_EXPLOG(GUIDLog, sid);
    if (!g_ClientLog)
	INIT_EXPLOG(ClientLog, sid);
    if (!g_PositionLog)
	INIT_EXPLOG(PositionLog, sid);
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
