////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  GameDatabase.cpp

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#include "GameDatabase.h"
#include "GameObject.h"

    GameDatabase *GameDatabase::m_Instance = NULL;

GameDatabase *GameDatabase::GetInstance() {
    if (m_Instance == NULL) {
	m_Instance = new GameDatabase();
    }
    return m_Instance;
}

GameDatabase::GameDatabase::GameDatabase() {
}

GameDatabase::~GameDatabase() {
    for (DataSourceListIter it = m_Sources.begin();
	 it != m_Sources.end(); it++) {
	delete *it;
    }
}

void GameDatabase::AddDataSource(GameDataSource *src) 
{
    m_Sources.push_back(src);
}

EventToken *GameDatabase::Preload(GUID globalID, uint32 prio) 
{
    for (DataSourceListIter it = m_Sources.begin();
	 it != m_Sources.end(); it++) {
	GameDataSource *src = *it;
	if (src->CanLoad(globalID)) {
	    EventToken *tok = src->Preload(globalID, prio);
	    ASSERT(tok);
	    m_TokenMap[tok] = src;
	    return tok;
	}
    }
    return NULL;
}

void GameDatabase::FreeToken(EventToken *tok)
{
    TokenMapIter p = m_TokenMap.find(tok);
    ASSERT(p != m_TokenMap.end());
    p->second->FreeToken(tok);
    m_TokenMap.erase(p);
}

GameObject *GameDatabase::Load(GUID globalID, uint32 prio)
{
    for (DataSourceListIter it = m_Sources.begin();
	 it != m_Sources.end(); it++) {
	GameDataSource *src = *it;
	// XXX -- here we are assuming that if CanLoad() returned in Preload
	// then it will also return true here so that inspecting the sources
	// in the same order will give us the same first result
	if (src->CanLoad(globalID)) {
	    return src->Load(globalID, prio);
	}
    }
    return NULL;
}

EventToken *GameDatabase::Store(GameObject *obj, uint32 prio)
{
    for (DataSourceListIter it = m_Sources.begin();
	 it != m_Sources.end(); it++) {
	GameDataSource *src = *it;
	// XXX -- here we are assuming that CanStore() returns true on
	// only 1 datasource...
	if (src->CanStore(obj)) {
	    EventToken *tok = src->Store(obj, prio);
	    ASSERT(tok);
	    m_TokenMap[tok] = src;
	    return tok;
	}
    }
    return NULL;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
