////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#ifndef DUMMY_MANAGER_H
#define DUMMY_MANAGER_H

#include <om/Manager.h>

///////////////////////////////////////////////////////////////////////////////

/**
 * Manager "subclass" that does nothing. This is used when we want to
 * disable the manager and mercury.
 */
class DummyManager : public Manager
{
 private:

    void SleepFor(uint32 msec);

 public:

    DummyManager();
    virtual ~DummyManager() {}

    virtual void Exec(uint32 timeout) { SleepFor(timeout); }
    virtual void Send(uint32 timeout) { SleepFor(timeout); }
    virtual void Recv(uint32 timeout, bool doMaintenance) { SleepFor(timeout); }
    virtual void Maintenance(uint32 timeout) {}
    virtual void Merc(uint32 timeout) {}
    virtual void Migrate(GObject *obj, sid_t target) {}
    virtual void AddObject(GObject *obj) {}
    virtual void DeleteObject(GObject *obj) {}
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
