////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#include "DummyManager.h"
#include <mercury/options.h>

void DummyManager::SleepFor(uint32 msec) {
    if (msec > 0) {
	OS::SleepMillis(msec);
    }
}

DummyManager::DummyManager() : Manager() {
    //
    // Only thing dummy manager has to to is allocate SID and GUIDs
    //
    struct hostent *entry = gethostbyname(g_Preferences.hostname);
    if (entry)
	g_LocalSID.m_IP = ((struct in_addr *) entry->h_addr)->s_addr;
    else
	g_LocalSID.m_IP = inet_addr(g_Preferences.hostname);
    g_LocalSID.m_Port = g_Preferences.port + 5000; 

    m_UniqueGUID.m_IP       = g_LocalSID.GetIP();
    m_UniqueGUID.m_Port     = g_LocalSID.GetPort();
    m_UniqueGUID.m_LocalOID = 0;

    Manager::m_Instance = this;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
