#!/bin/sh
#
# This is a simple demo that shows the model game workload. It starts up
# $NSERVERS on the localhost and runs 4 bots on each. It then starts up
# the visualizer to view the bots in action. When the visualizer exits,
# the experiment is killed.
#
# NOTE: you must be able to 'ssh localhost' without a password. For example,
# load your public key into ssh-agent and add it to ~/.ssh/authorized_keys.

NSERVERS=4
BASE=`dirname $0`;

# in topdir
cd $BASE/../.. || exit 1
TOPDIR=`pwd`

# (1) run some servers
cd Colyseus/run || exit -1
# opts=-B --nolog
./RunV2.pl TestgameConf.pl --nolat -x -v $NSERVERS -z 127.0.0.1 --mapdir $TOPDIR/Data/maps/16-players --nbots 4 127.0.0.1 -t $TOPDIR > /tmp/modelgame.demo1.exp || exit 1

# (2) start the visualizer
cd ../apps/viz
LD_LIBRARY_PATH=$TOPDIR/Colyseus:$TOPDIR/Merc:. ./viz --no-links --no-psubs --map $TOPDIR/Data/maps/16-players

# (3) kill the experiment
cd ../../run
./RunV2.pl TestgameConf.pl -k 127.0.0.1
