
#ifndef __VIZ_COMMON_H__
#define __VIZ_COMMON_H__

#include <SDL/SDL.h>

#if defined(_WIN32)
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
//#include <SDL/SDL_image.h>
#elif defined (__APPLE__)
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
//#include <SDL_image/SDL_image.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
//#include <SDL/SDL_image.h>
#endif

#include <gameapi/common.h>
#include <util/TimeVal.h>

#define glError() { \
   GLenum err = glGetError(); \
   while (err != GL_NO_ERROR) { \
      printf("glError: %s caught at %s:%u\n", (char *)gluErrorString(err), __FILE__, __LINE__); \
      err = glGetError(); \
   } \
}

extern TimeVal gCurrFrameTime;

#endif
