/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:nil -*- */

#ifndef __FONT_UTIL_H__
#define __FONT_UTIL_H__

#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

/**
 * Initialize SDL/GL font lib
 */
int Text_Init(void);

/**
 * Set the default font to use.
 */
int Text_SetFont(const char *ttf_path, int size);

/**
 * Print the text as a GL texture.
 *
 * @param color the GL color to use
 * @param location the location in GL (x,y) space (upper left corner)
 * @param height the desired height of the text in GL units
 * @returns the width of the text in GL units.
 */
float Text_Print(const char *text,
                 const Vec3& color, 
                 const Vec3& location,
                 float height = 1.0,
                 bool center = false);

float Text_Print(const char *text,
                 TTF_Font *font,
                 const Vec3& color, 
                 const Vec3& location,
                 float height = 1.0,
                 bool center = false);

float Text_Print(const char *text, 
                 TTF_Font *font,
                 SDL_Color color,
                 float x, float y,
                 float height = 1.0,
                 bool center = false);

#endif
