////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  2DTileWorld.h

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __2D_TILE_WORLD_H__
#define __2D_TILE_WORLD_H__

#include <mercury/common.h>
#include <gameapi/GameWorld.h>
#include <gameapi/GameObject.h>

    struct Tile : public Serializable {
	typedef enum { GROUND, ABYSS, WALL } TileType;

	TileType type;

	Tile() : type(GROUND) {}
	Tile(TileType t) : type(t) {}
	Tile(Packet *pkt) {
	    type = (TileType)pkt->ReadByte();
	}
	void Serialize(Packet *p) {
	    p->WriteByte((byte)type);
	}
	uint32 GetLength() {
	    return 1;
	}
	void Print(FILE *) {
	}
    };

struct TileChunk : public StaticGameObject {
    int w, h;
    Tile **tiles;
    TileChunk *around[3][3]; // row x column

    TileChunk(const GUID& guid, int w, int h);
    virtual ~TileChunk();
    TileChunk(Packet *pkt);
    void Serialize(Packet *pkt);
    uint32 GetLength();
    void Print(FILE *) {}
};

struct TileRegion {
    TileChunk *middle;

    TileRegion(TileChunk *middle);
    inline Tile GetTile(int i, int j);
};

struct less_IntPair {
    bool operator()(const pair<int,int>& a, const pair<int,int> b) {
	return a.first < b.first || (a.first == b.first && a.second < b.second);
    }
};

typedef map<pair<int,int>, TileChunk *> ChunkMap;
typedef ChunkMap::iterator ChunkMapIter;

class TileWorld : public GameWorld {
 private:
    friend class GameStore;
    friend class DynamicObjectStore;

    // absolute dimensions of the entire game world
    BBox dims;
    int chunksize;
    // portions of the game map that are currently loaded
    ChunkMap chunks;

    TileRegion GetChunks(const Vec3& pt);

 protected:

    TileWorld(BBox dimensions, int chunksize);
    virtual ~TileWorld();

    virtual void Link(GameObject *obj);
    virtual void Unlink(GameObject *obj);
    virtual uint32 GetAreaOfInterest(list<BBox> *toFill, 
				     DynamicGameObject *obj);
    virtual void DoWork();
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
