////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

 ***************************************************************************/

#ifndef __SIMPLE_MOVABLE_H__
#define __SIMPLE_MOVABLE_H__

#include <gameapi/GameObject.h>
#include "SimpleTypeCodes.h"

class SimpleMovable : public DynamicGameObject {
private:
    Vec3 velocity;
    Vec3 viewangles;              // recalc each frame depending on action and movement
protected:
    bool deleted;
    void MarkForDeletion();
public:
    bool IsMarkedForDeletion() const { return deleted; }

    SimpleMovable(GameManager *manager, gTypeCode t = SIMPLE_MOVABLE);
    SimpleMovable(GObjectInfoIface *info, gTypeCode t = SIMPLE_MOVABLE);

    virtual ~SimpleMovable();

    const Vec3& GetVelocity() { return velocity; }

    void SetVelocity(const Vec3& new_velocity) {
	for (int i=0; i<3; i++) {
	    ASSERT( !isnan(new_velocity[i]) );
	    if (velocity[i] != new_velocity[i]) {
		SetDeltaMaskField(DynamicGameObject::GetDeltaMaskBits()+i);
		velocity[i] = new_velocity[i];
	    }
	}
    }

    const Vec3& GetViewAngles ();
    void SetViewAngles (const Vec3& angles);

    void SetVolume(const BBox& vol) {
	// XXX TODO
	m_Volume = vol;
    }

    virtual const uint32 GetDeltaMaskBits() { 
	return DynamicGameObject::GetDeltaMaskBits() + 3; 
    }

    // This returns the AOI we have given our current postion
    // and who might have moved into it given the delay parameters
    virtual void GetPredictedAreaOfInterest(list<BBox> *toFill, 
	    GameWorld *world);
    virtual void FillEvents(EventList *reg, EventList *unreg, EventSet *curr);
    virtual uint32 IsInterested(const Vec3& pt, gTypeCode t);
    virtual uint32 IsInterested(const BBox& vol, gTypeCode t);
    virtual void RunThink(GameManager *manager, real32 delta);

    virtual const DeltaMask& GetInitDeltaMask();
    virtual void PackUpdate(Packet *buffer, const DeltaMask& mask);
    virtual void UnpackUpdate(Packet *buffer, const DeltaMask& mask, 
	    list<GameObjectRef *> *unresolved);

    virtual uint32 GetRegion();

    virtual void PrintFields(ostream& out);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
