////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

 ***************************************************************************/

#ifndef __SIMPLE_MISSILE_H__
#define __SIMPLE_MISSILE_H__

#include "SimpleGame.h"
#include "SimpleMovable.h"
#include "SimplePlayer.h"

class SimpleMissile : public SimpleMovable {
private:
    sint16 lifetime; // number of frames to live
public:
    gRef<SimplePlayer> owner;
protected:

public:

    static const real32 FLY_VELOCITY = 80;
    static const uint16 LIFETIME = 30;
    static const uint32 DAMAGE = 10;

    static uint32 SUB_PREDICTION;

    static void SetSubPrediction(uint32 msec) {
	ASSERT(!SimpleGame::IsInited());
	SUB_PREDICTION = msec;
    }

    SimpleMissile(GameManager *manager);
    SimpleMissile(GObjectInfoIface *info);

    virtual ~SimpleMissile();

    void SetDirection(const Vec3& dir) {
	ASSERTDO(dir.Length() > 0, WARN << "invalid dir=" << dir << endl);
	SetVelocity(FLY_VELOCITY * dir.Normalize());
    }

    void SetOwner(SimplePlayer *p) {
	SetDeltaMaskField( SimpleMovable::GetDeltaMaskBits() + 1 );
	owner = p;
    }

    sint16 GetLifetime() {
	return lifetime;
    }

    void SetLifetime(sint16 v) {
	SetDeltaMaskField( SimpleMovable::GetDeltaMaskBits() );
	lifetime = v;
    }

    virtual const uint32 GetDeltaMaskBits() { 
	return SimpleMovable::GetDeltaMaskBits() + 2; 
    }

    virtual void AttachedTo(GUIDList *others) {
	if (owner != NULL)
	    others->push_back(owner->GetGUID());
    }

    virtual VisType GetVisualizerType () { return VisType_Missile; }

    virtual uint32 GetAreaOfInterest(list<BBox> *toFill, GameWorld *w);
    virtual uint32 IsInterested(const Vec3& pt, gTypeCode t);
    virtual uint32 IsInterested(const BBox& vol, gTypeCode t);
    virtual void RunThink(GameManager *manager, real32 delta);

    virtual const DeltaMask& GetInitDeltaMask();
    virtual void PackUpdate(Packet *buffer, const DeltaMask& mask);
    virtual void UnpackUpdate(Packet *buffer, const DeltaMask& mask, 
	    list<GameObjectRef *> *unresolved);
    virtual uint32 ExpectedLifetime();

    virtual void PrintFields(ostream& out);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
