////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#include "SimpleInterestFactory.h"
#include "PredictiveInterestFilter.h"
#include <gameapi/MergingInterestFilter.h>
#include "SimpleGame.h"
#include "SimpleMovable.h"
#include "SimplePlayer.h"
#include "SimpleMissile.h"
#include <gameapi/GameManager.h>

const real32 SimpleInterestFactory::SUB_EXPANSION_FACTOR;

FilterChain *SimpleInterestFactory::CreateIndividual(DynamicGameObject *o)
{
    ASSERT(SimpleGame::IsInited());

    FilterChain *c = new FilterChain();
    real32 vel  = 0;
    uint32 pred = 0;

    switch(o->GetType()) {
    case SIMPLE_MOVABLE:
	vel  = 0;
	pred = 0;
	break;
    case SIMPLE_PLAYER:
	vel  = SimplePlayer::WALK_VELOCITY;
	pred = SimplePlayer::SUB_PREDICTION; 
	break;
    case SIMPLE_MISSILE:
	vel  = SimpleMissile::FLY_VELOCITY;
	pred = SimpleMissile::SUB_PREDICTION;
	break;
    default:
	WARN << "unknown object type: " << o->GetType() << endl;
	ASSERT(0);
    }

    PredictiveInterestFilter *f = 
	new PredictiveInterestFilter(o, vel, pred, 
				     &SimpleGame::predictionParams);
    c->push_back(f);
    return c;
    //return NullInterestFactory::CreateIndividual(o);
}

FilterChain *SimpleInterestFactory::CreateGlobal() {
    ASSERT(SimpleGame::IsInited());

    FilterChain *c = new FilterChain();

    // If we are using a pseudo-DHT, then we should first convert all the
    // interests to DHT region keys before letting the MergingInterestFilter
    // eliminate duplicates based on old stuff still alive in the system
    if (GameManager::publishAsDHTRegions) {
	SimpleGame *g = static_cast<SimpleGame *>(GameManager::GetInstance()->GetModule());
	DHTInterestFilter *df =
	    new DHTInterestFilter(g->GetHasher());
	c->push_back(df);
    }

    MergingInterestFilter *f = 
	new MergingInterestFilter(SUB_EXPANSION_FACTOR);
    c->push_back(f);

    return c;
}

void SimpleInterestFactory::Delete(FilterChain *chain)
{
    if (chain->size() > 0) {
	for (FilterChainIter it = chain->begin(); 
	     it != chain->end(); it++) {
	    delete *it;
	}
	delete chain;
    }
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
