////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __FILE_DATASOURCE_H__
#define __FILE_DATASOURCE_H__

#include <string>
#include <map>
#include <util/Thread.h>
#include <util/Mutex.h>
#include <util/Queue.h>
#include <gameapi/GameDatabase.h>

    struct FDS_Info {
	typedef enum { LOAD, STORE, OK, ERROR } FDS_Type;

	FDS_Type type;
	GUID guid;
	GameObject *obj;
	EventToken *tok;

	FDS_Info(FDS_Type type, 
		 const GUID& guid, 
		 EventToken *tok) : 
	    type(type), guid(guid), obj(NULL), tok(tok) {}

	FDS_Info(FDS_Type type, 
		 GameObject *obj, 
		 EventToken *tok) : 
	    type(type), guid(GUID_NONE), obj(obj), tok(tok) {}
    };

typedef map<GUID, GameObject *, less_GUID> GameObjectCache;
typedef GameObjectCache::iterator GameObjectCacheIter;

class FileDataSource;

struct FDS_Loader : public Thread {
    FileDataSource *src;
    string dir;
    Queue<FDS_Info> todo;
    Queue<FDS_Info> done;

    FDS_Loader(const char *dir, FileDataSource *src) : 
	src(src), dir(dir) {}

    void Run();
    void DoWork();
};

class FileDataSource : public GameDataSource {
    friend class FDS_Loader;
 private:
    GUID min, max;
    Mutex lock;
    GameObjectCache cache;
    map<GUID, EventToken *, less_GUID> pending_loads;
    set<EventToken *> waiting;
    set<EventToken *> todelete;
    FDS_Loader *loader;
 public:
    FileDataSource(const char *dir, const GUID& min, const GUID& max);
    virtual ~FileDataSource();

    virtual bool CanLoad(const GUID& globalID);
    virtual bool CanStore(GameObject *obj);
    virtual EventToken *Preload(const GUID& globalID, uint32 prio);
    virtual GameObject *Load(const GUID& globalID, uint32 prio);
    virtual EventToken *Store(GameObject *obj, uint32 prio);
    virtual void FreeToken(EventToken *tok);

};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
