#ifndef __DONNYBROOK_MANAGER__H
#define __DONNYBROOK_MANAGER__H

#include <gameapi/GameManager.h>
#include "SimpleMovable.h"

struct DbrookObjInfo {
    GUID   colyseus_guid;       // colyseus-style large GUID
    int    dbrook_guid;         // densely packed integer GUID for the donnybrook logs
    int    parent;              // dbrook_guid of the owner object
    bool   team;                // team of object (if ctf player)
    int    machine;             // which machine does this object reside on
    int    classtype;           // class of the object
};

typedef map<GUID, DbrookObjInfo, less_GUID> DbrookObjMap;
typedef DbrookObjMap::iterator DbrookObjMapIter;


class DonnybrookManager {
private:
    typedef enum {
	EV_QUIT,
	EV_UP,
	EV_DOWN,
	EV_CREATE,
	EV_UPDATE,
	EV_DELETE,
	EV_DAMAGE
    } EventType;

    typedef enum { 
	OBJ_PLAYER,
	OBJ_ITEM,
	OBJ_MISSILE
    } ObjectType;

    int m_NumMachines;
    GameManager *m_GameManager;
    DbrookObjMap m_ObjectMap;
    FILE *m_Logfp;
    
    // We want to make sure that the first N guids correspond 
    // to the N players in the game
    int m_Players;  
    int m_NonPlayers;
public:
    DonnybrookManager (GameManager *m, int machines);
    ~DonnybrookManager ();

    void RecordObjectCreate (SimpleMovable *obj);
    void RecordObjectDelete (SimpleMovable *obj);
    void RecordObjectUpdate (SimpleMovable *obj);
    void RecordDamage (SimpleMovable *source, SimpleMovable *target);

private:
    void generateStartEvent ();
    void generateQuitEvent ();
    void generateChurnEvents (int state);
    void generateCreateEvent (SimpleMovable *obj, DbrookObjInfo& info);
    void generateUpdateEvent (SimpleMovable *obj, DbrookObjInfo& info);
    void generateDeleteEvent (SimpleMovable *obj, DbrookObjInfo& info);
    void generateDamageEvent (DbrookObjInfo& source, DbrookObjInfo& target);

    int getFullObjectSize (SimpleMovable *obj);
    int getDeltaObjectSize (SimpleMovable *obj);
};

#endif /* __DONNYBROOK_MANAGER__H */
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
