////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#include "DHTInterestFilter.h"
#include "SimpleWorld.h"
#include <gameapi/GameManager.h>

DHTHasher::DHTHasher(uint32 keydim) : m_KeyDim(keydim) {}

/* from http://www.concentric.net/~Ttwang/tech/inthash.htm */
static uint32 inthash(uint32 key)
{
    key += (key << 12);
    key ^= (key >> 22);
    key += (key << 4);
    key ^= (key >> 9);
    key += (key << 10);
    key ^= (key >> 2);
    key += (key << 7);
    key ^= (key >> 12);
    return key;
}

real32 DHTHasher::Hash(uint32 region)
{
    uint32 k; 
    real32 frac;
    static uint32 MAX_UINT32 = 0xFFFFFFFF;

#if 0
    // XXX HACKY !!!
    static uint64 a = 139990829, b = 1361165756;
    static uint64 p = 1500450271;

    k = (uint32)( ((a*region + b) % p) & 0x00000000FFFFFFFFULL );
    frac = (real32) k / (real32) MAX_UINT32;    /* it should be 'p' and not MAX_UINT32, i think - Ashwin [10/03/2005] */
#else
    k = inthash (region);
    frac = (real32) k / (real32) MAX_UINT32;
#endif

    SimpleWorld *w = 
	static_cast<SimpleWorld *>(GameManager::GetInstance()->GetWorld());

    // convert region ID into DHT key
    real32 max = w->GetExtent().max[m_KeyDim];
    real32 min = w->GetExtent().min[m_KeyDim];
    real64 range = max - min;

    real32 ret = min + (real32)( frac * range );

    // cerr << "frac=" << frac << endl;
    // cerr.flush ();
    return ret;
}

///////////////////////////////////////////////////////////////////////////////

DHTInterestFilter::DHTInterestFilter(DHTHasher *h) : m_Hasher(h) {}

DHTInterestFilter::~DHTInterestFilter() {}

AreaOfInterest *DHTInterestFilter::Filter(AreaOfInterest *in) {
    SimpleWorld *w = 
	static_cast<SimpleWorld *>(GameManager::GetInstance()->GetWorld());
    map<uint32, AnnotatedBBox *> regions;

    for (AreaOfInterestIter it = in->begin(); it != in->end(); it++) {
	vector<uint32> regs;
	w->GetRegions(&regs, *(*it)->GetBBox());

	for (uint32 i=0; i<regs.size(); i++) {
	    map<uint32, AnnotatedBBox *>::iterator p = regions.find(regs[i]);
	    if (p != regions.end()) {
		AnnotatedBBox *box = p->second;
		box->AddGUIDs( (*it)->GetGUIDs() );
		box->SetTTL( MAX( box->GetTTL(), (*it)->GetTTL() ) );

		BBox *bbox = box->GetBBox();

		for (uint32 j=0; j<2; j++) {
		    bbox->min[j+1] = MIN(bbox->min[j+1], (*it)->GetBBox()->min[j]);
		    bbox->max[j+1] = MAX(bbox->max[j+1], (*it)->GetBBox()->max[j]);
		    ASSERT(bbox->min[j+1] < bbox->max[j+1]);
		}
	    } else {
		// XXX - This ONLY WORKS right now because we don't ever
		// need to read a bbox back from an Interest! FIXME!
		BBox key;
		real32 key_val = m_Hasher->Hash(regs[i]);
		ASSERT( m_Hasher->GetKeyDim() == 0 );
		key.min[m_Hasher->GetKeyDim()] = key_val;
		key.max[m_Hasher->GetKeyDim()] = key_val;

		for (uint32 j=0; j<2; j++) {
		    key.min[j+1] = (*it)->GetBBox()->min[j];
		    key.max[j+1] = (*it)->GetBBox()->max[j];
		    ASSERT(key.min[j+1] < key.max[j+1]);
		}

		AnnotatedBBox *box = 
		    new AnnotatedBBox(key, (*it)->GetGUIDs(), (*it)->GetTTL());
		regions.insert( pair<uint32, AnnotatedBBox *>(regs[i], box) );
	    }
	}
    }

    AreaOfInterest *out = new AreaOfInterest();
    for (map<uint32, AnnotatedBBox *>::iterator it = regions.begin();
	 it != regions.end(); it++) {

	//INFO << "subscribing: " << *it->second->GetBBox() << endl;

	out->push_back(it->second);
    }

    return out;
}

void DHTInterestFilter::Delete(AreaOfInterest *aoi) {
    for (AreaOfInterestIter it = aoi->begin(); it != aoi->end(); it++) {
	delete *it;
    }
    delete aoi;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
