////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  sim_shared.h

begin           : Oct 16, 2003
version         : $Id: sim_shared.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __SIM_SHARED_H__
#define __SIM_SHARED_H__

#include <framework2/common.h>
#include <framework2/GEvent.h>
#include <framework2/GObject.h>
#include <framework2/GUpdate.h>

    extern const attrkey_t SIZE;
extern const attrkey_t TYPE;
extern const attrkey_t OBJ_SIZE;
//extern const attrkey_t X;
//extern const attrkey_t Y;
//extern const attrkey_t Z;
extern const attrkey_t NODE;

extern const attrkey_t ATTRS[];
#define NUM_ATTRS 4

// types
extern const string PLAYER;
extern const string ITEM;
extern const string MISSILE;

// costs
extern const ObjectCosts PLAYER_COSTS;
extern const ObjectCosts MISSILE_COSTS;
extern const ObjectCosts ITEM_COSTS;

bwidth_t clientIn(int num);
bwidth_t clientOut(int num);

uint32 subSize(Interest *i);
uint32 pubSize(GEvent *e);
uint32 updateSize(GUpdate *i);
uint32 objSize(GObject *i);

uint32 repDataSize(attrkey_t type);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
