////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  sim_shared.cpp

begin           : Oct 16, 2003
version         : $Id: sim_shared.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include "sim_shared.h"
#include "g_local.h"

    // attributes
    const attrkey_t SIZE = string("size");
const attrkey_t TYPE = string("type");
const attrkey_t OBJ_SIZE = string("obj_size");
//const attrkey_t X    = string("x");
//const attrkey_t Y    = string("y");
//const attrkey_t Z    = string("z");
const attrkey_t NODE   = string("node");

// !!! redefine NUM_ATTRS in sim_shared.h if you change this!
const attrkey_t ATTRS[] = { NODE, TYPE, OBJ_SIZE, SIZE/*not really used*/ };

// types
const attrkey_t PLAYER  = string("player");
const attrkey_t MISSILE = string("missile");
const attrkey_t ITEM    = string("item");

#define FRAME_INTERVAL 100 /* ms */
// type_tag
#define SUB_OVERHEAD (0)
// server stats + guid + src_sid
#define PUB_OVERHEAD (0) /* B */

// type costs: TODO: IP overhead?
// client_in, client_out, pub_rate, sub_rate, interest_stable, interest_discard
const ObjectCosts PLAYER_COSTS = 
    { (bwidth_t)( (3000.0)/1000 ), // 24kbps = 3KBps = 3B/ms
      (bwidth_t)( (4000.0)/1000 ), // 40kbps = 4KBps = 4B/ms
      (bwidth_t)( (PUB_OVERHEAD+16*4 ) / (float)FRAME_INTERVAL ),
      (bwidth_t)( 12.3*(SUB_OVERHEAD+4) / (float)FRAME_INTERVAL ),
      (gtime_t) ( 1500/* FIXME */ ),
      (gtime_t) ( 2000/* FIXME */ ),
    };
const ObjectCosts MISSILE_COSTS = 
    { (bwidth_t)( 0 ),
      (bwidth_t)( 0 ),
      (bwidth_t)( (PUB_OVERHEAD+16*4 ) / (float)FRAME_INTERVAL ),
      (bwidth_t)( 20.4*(SUB_OVERHEAD+4) / (float)FRAME_INTERVAL ),
      (gtime_t) ( 1000/* FIXME: don't care about transient objects... */ ),
      (gtime_t) ( 0/* FIXME */ ),
    };
const ObjectCosts ITEM_COSTS = 
    { (bwidth_t)( 0 ),
      (bwidth_t)( 0 ),
      (bwidth_t)( (PUB_OVERHEAD+(4*4)) / (float)FRAME_INTERVAL ),
      (bwidth_t)( 14.7*(SUB_OVERHEAD+4) / (float)FRAME_INTERVAL ),
      (gtime_t) ( 1500/* FIXME */ ),
      (gtime_t) ( 3000/* FIXME */ ),
    };

bwidth_t clientIn(int num) {
    return num*PLAYER_COSTS.client_in;
}

bwidth_t clientOut(int num) {
    return num*PLAYER_COSTS.client_out;
}

uint32 subSize(Interest *i) {
    // must be one bsp tree node: exact match
    return SUB_OVERHEAD + 4;
}

uint32 pubSize(GEvent *e) {
    Value *v = e->GetAttribute(SIZE);
    ASSERT(v != NULL);
    // overhead + data
    return PUB_OVERHEAD + v->m_Ival;
}

uint32 updateSize(GUpdate *u) {
    Value *v = u->getAttribute(SIZE);
    ASSERT(v != NULL);
    // assume header = type_tag
    // guid + data
    return 1 + 4 + v->m_Ival;
}

uint32 objSize(GObject *o) {
    Value v = o->getAttribute(OBJ_SIZE);
    ASSERT(v.m_Type != ATTR_INVALID);
    // assume header = type_tag
    // guid + subs[bsp_tree_node] + data (attributes)
    return 1 + 4 + 4*o->getSubscription().size() + v.m_Ival;
}

// the size of the data required to reconstruct a replica from the object
// we currently assume all publications are the same size???
uint32 repDataSize(attrkey_t type) {
    if ( type == PLAYER) {
	return (uint32)(PLAYER_COSTS.pub_rate*FRAME_INTERVAL - PUB_OVERHEAD);
    } else if (type == MISSILE) {
	return (uint32)(MISSILE_COSTS.pub_rate*FRAME_INTERVAL - PUB_OVERHEAD);
    } else if (type == ITEM) {
	return (uint32)(ITEM_COSTS.pub_rate*FRAME_INTERVAL - PUB_OVERHEAD);
    } else {
	Debug::die("unknown type: %s", type.c_str());
    }
    return 0;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
