////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  main.cpp

begin           : Oct 16, 2003
version         : $Id: main.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include <framework2/common.h>
#include "sim_shared.h"
    //#include "Distribution.h"
#include "God.h"
#include "SimProtocolLayer.h"
#include "SimObject.h"
#include "WorkloadApp.h"

    // Globals
    char    g_TraceFile[255];
char    g_InitialFile[255];
char    g_LogFile[255];
char    g_Policy[255];
char    g_RegionMapFile[255];
int     g_RandSeed;
gtime_t g_StartTime;
gtime_t g_StopTime;
uint32  g_TimeMultiplier;
int     g_NumServers;
gtime_t g_MigrateInterval;
gtime_t g_InterestInterval;
gtime_t g_WindowSize;
ServerParams g_ServerParams;

///////////////////////////////////////////////////////////////////////////////

// Shamelessly copied from the caduceus code :)

#define OPT_NOARG        0x01
#define OPT_INT          0x02
#define OPT_STR          0x04  
#define OPT_FLT          0x08
#define OPT_CHR          0x10
#define OPT_BOOL         0x20

struct options_struct {
    char shortletter;
    char *longword;
    int  flags;
    char *comment;
    void *varptr;
    char *default_val;
    void *val_to_set;
    /* sometimes, for OPT_NOARG, we need to set different values,
       for example: if option -m is given, we set send_pubs to
       be "false"; sometimes we might want to set send_pubs to
       "true" when the option is given! */
};

struct options_struct option_config[] =
    {
	{ 't', "tracefile", OPT_STR,
	  "workload trace file", g_TraceFile, "tracefile", (void *) 0 },
	{ 'i', "initfile", OPT_STR,
	  "{initial placement file,RANDOM,SMART}", 
	  g_InitialFile, "RANDOM", (void *) 0 },
	{ 'l', "logfile", OPT_STR,
	  "output log file", g_LogFile, "logfile", (void *) 0 },	
	{ 'c', "policy", OPT_STR,
	  "{static,region,loadbalance,random}", g_Policy, "static", 
	  (void *) 0 },
	{ 'e', "regionmap", OPT_STR,
	  "region map file for regiion policy", g_RegionMapFile, "NONE", 
	  (void *) 0 },
	{ 'r', "randseed", OPT_INT,
	  "random seed", &g_RandSeed, "42", (void *) 0 },
	{ 't', "start", OPT_INT,
	  "start time", &g_StartTime, "0", (void *) 0 },
	{ 'p', "stop", OPT_INT,
	  "stop time", &g_StopTime, "30000" /* 30sec */, (void *) 0 },
	{ 's', "servers", OPT_INT,
	  "number of servers", &g_NumServers, "10", (void *) 0 },	
	{ 'x', "xtime", OPT_INT,
	  "multiplier on trace timestamps", &g_TimeMultiplier, "100", (void *) 0 },

	{ 'm', "migrate_interval", OPT_INT,
	  "migrate interval", &g_MigrateInterval, "1000" /* 1sec */, (void *) 0 },
	{ 'n', "interest_interval", OPT_INT,
	  "interest interval", &g_InterestInterval, "100" /* 100ms */, (void *) 0 },
	{ 'w', "window", OPT_INT,
	  "bwidth window size", &g_WindowSize, "1000" /* 1sec */, (void *) 0 },

	{ 'I', "capacity_in", OPT_FLT,
	  "inbound capacity (B/ms)",  &(g_ServerParams.capacity_in), 
	  "187.5" /*1.5 Mbps */, (void *) 0 },
	{ 'O', "capacity_out", OPT_FLT,
	  "outbound capacity (B/ms)",  &(g_ServerParams.capacity_out), 
	  "187.5" /*1.5 Mbps */, (void *) 0 },
	{ '1', "lowwater_in", OPT_FLT,
	  "inbound low water mark (B/ms)",  &(g_ServerParams.lowwater_in), 
	  "90", (void *) 0 },
	{ '2', "lowwater_out", OPT_FLT,
	  "outbound low water mark (B/ms)",  &(g_ServerParams.lowwater_out), 
	  "90", (void *) 0 },
	{ '3', "highwater_in", OPT_FLT,
	  "inbound high water mark (B/ms)",  &(g_ServerParams.highwater_in), 
	  "140", (void *) 0 },
	{ '4', "highwater_out", OPT_FLT,
	  "outbound high water mark (B/ms)",  &(g_ServerParams.highwater_out), 
	  "140", (void *) 0 },

	{ 0, 0, 0, 0, 0, 0, 0 },
    };

///////////////////////////////////////////////////////////////////////////////

void PrintUsage() {
    struct options_struct *ptr;

    fprintf(stderr, "usage: opsim [options]:\n");
    for (ptr = option_config; ptr->longword; ptr++ ) {
	fprintf(stderr,"\t-%c,--%s:\t%s (default: %s)\n", ptr->shortletter, 
		ptr->longword, ptr->comment, ptr->default_val);
    }
    fprintf(stderr, "\n");
}

void _AssignValue(struct options_struct *ptr, char *value) {
    if (ptr->flags & OPT_CHR) {
	*(char *) ptr->varptr = *value;
    }
    else if (ptr->flags & OPT_INT) {
	*(int *) ptr->varptr = atoi(value);
    } 
    else if (ptr->flags & OPT_FLT) {
	*(float *) ptr->varptr = atof(value);
    }
    else if (ptr->flags & OPT_STR) {
	strcpy((char *) ptr->varptr, value);
    }
    else if (ptr->flags & OPT_BOOL) {
	bool toSet = (strcmp(value, "1") == 0 ? true : false);
	*((bool *) ptr->varptr) = toSet;
    }
}

void _ProcessOption(int *ref_i, struct options_struct *ptr, 
		    int argc, char *argv[]) {
    if (ptr->flags & OPT_NOARG) {
	_AssignValue(ptr, (ptr->val_to_set ? (char *) ptr->val_to_set : (char *) "1"));
    }
    else {
	int index = *ref_i + 1;
	ASSERT(index < argc);
	_AssignValue(ptr, argv[index]);

	*ref_i = *ref_i + 1;
    }
}

void AssignDefaults() {
    struct options_struct *ptr;

    for (ptr = option_config; ptr->longword; ptr++ ) {
	_AssignValue(ptr, ptr->default_val);
    }
}

void  DebugPrintOptions() {
    struct options_struct *ptr;

    fprintf(stderr, "Current option values...\n");
    for (ptr = option_config; ptr->longword; ptr++ ) {
	fprintf(stderr,"\t-%c,--%s:\t", ptr->shortletter, ptr->longword);
	if (ptr->flags & OPT_CHR) 
	    fprintf(stderr, "%c\n", *(char *) ptr->varptr);
	else if (ptr->flags & OPT_INT) 
	    fprintf(stderr, "%d\n", *(int *) ptr->varptr);
	else if (ptr->flags & OPT_FLT) 
	    fprintf(stderr, "%f\n", *(float *) ptr->varptr);
	else if (ptr->flags & OPT_STR) 
	    fprintf(stderr, "%s\n", (char *) ptr->varptr);
	else if (ptr->flags & OPT_BOOL) 
	    fprintf(stderr, "%s\n", (*((bool *) ptr->varptr) == true ? "true" : "false"));
    }
    fprintf(stderr, "\n");
}

void ProcessOptions(int argc, char *argv[]) {
    int i = 1;
    char sbuf[3], lbuf[24];
    struct options_struct *ptr;

    sbuf[0] = '-'; sbuf[2] = 0;
    lbuf[0] = lbuf[1] = '-';

    memset(&g_Preferences, 0, sizeof(g_Preferences));
    AssignDefaults();

    while (i < argc) {
	ptr = option_config;
	if (!strcmp(argv[i], "-h") || !strcmp(argv[i], "--help") || 
	    !strcmp(argv[i], "--h")) {
	    PrintUsage();
	    exit(0);
	}
	while (ptr->longword) {
	    sbuf[1] = ptr->shortletter;
	    strcpy(lbuf + 2, ptr->longword);

	    if (!strcmp(argv[i], sbuf) || !strcmp(argv[i], lbuf)) {
		_ProcessOption(&i, ptr, argc, argv);
		i++;
		break;
	    }
	    ptr++;
	}
	if (!ptr->longword) {
	    PrintUsage();
	    MercFatal("Invalid argument: %s\n", argv[i]);
	}
    }
}

///////////////////////////////////////////////////////////////////////////////

void registerTypes() {
    TypeTable::registerType(SIM_OBJECT_TYPE, OCF_SimObject, ECF_SimObject);
}

void initServerParams() {
    g_ServerParams.sub_dimensions.push_back(NODE);
}

/**
 * Entry point.
 */
int main(int argc, char **argv) {
    srand(g_RandSeed);
    //Distribution::Seed(g_RandSeed);

    strcpy(g_ProgramName, argv[0]);
    ProcessOptions(argc, argv);
    registerTypes();

    init_t initMethod;
    if ( !strcmp(g_InitialFile,"RANDOM") ) {
	initMethod = INIT_RANDOM;
    } else if ( !strcmp(g_InitialFile,"SMART") ) {
	initMethod = INIT_SMART;
    } else {
	initMethod = INIT_FILE;
    }

    God *god = new God(g_StartTime, g_TimeMultiplier, g_TraceFile,
		       initMethod, g_InitialFile);
    //#if DEBUG
    //_god = god;
    //#endif
    Logger *logger = new Logger(g_LogFile, god);
    ProtocolLayer *proto = new SimProtocolLayer(god, logger, g_WindowSize);

    initServerParams();

    for (int i=0; i<g_NumServers; i++) {
	SID sid;
	sid.addr = i;
	sid.port = 0;
	Policy *policy = NULL;
	gtime_t migrateInterval = 0, interestInterval = 0;

	if (! strcmp(g_Policy, "static") ) {
	    policy = new StaticPlacementPolicy();
	    migrateInterval  = (gtime_t)-1;
	    interestInterval = g_InterestInterval;
	} else if (! strcmp(g_Policy, "random") ) {
	    policy = new RandomPlacementPolicy();
	    migrateInterval  = (gtime_t)-1;
	    interestInterval = g_InterestInterval;
	} else if (! strcmp(g_Policy, "loadbalance") ) {
	    policy = new LoadBalancedPolicy();
	    migrateInterval = g_MigrateInterval;
	    interestInterval = g_InterestInterval;
	} else if (! strcmp(g_Policy, "region") ) {
	    policy = new RegionPlacementPolicy(g_NumServers,
					       !strcmp(g_RegionMapFile,
						       "NONE") ?
					       NULL :
					       g_RegionMapFile);
	    migrateInterval  = (gtime_t)-1;
	    interestInterval = g_InterestInterval;
	} else {
	    Debug::die("unknown policy: %s", g_Policy);
	}
	Server *s = new Server(sid, &g_ServerParams, proto, policy);
	GApplication *app = new WorkloadApp(s, migrateInterval, 
					    interestInterval);
	god->addServer(s);
    }

    god->run(g_StopTime);

    delete( god );
    delete( logger );
    delete( proto );
    // TODO: delete rest

    //god->dumpEventQueue(cerr);

    return 0;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
