#!/usr/bin/perl -w

use warnings;
use strict;

if ( $#ARGV < 1 ) {
    print "usage:  ./compute_bwidth_breakdown.pl bwidth_file out_dir\n";
    exit;
}


my $bwidth_file = $ARGV[0];
my $out_dir = $ARGV[1];


my @types = ("PUB_RECV", "UPDATE_RECV", "MIGRATE_RECV", "CLIENT_RECV", "SUB_SEND", "PUB_SEND", "UPDATE_SEND", "MIGRATE_SEND", "CLIENT_SEND", "ROUTEIN", "ROUTEOUT", "TOTIN", "TOTOUT");

foreach my $type (@types) {
  my $out_file = "$bwidth_file.$type";
  my $cmd = "./plot_tot_bwidth.pl -f $type -b 9000000 -o $out_file $bwidth_file";
  print "$cmd\n";
  system $cmd;
}
