////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  WorkloadApp.h

begin           : Nov 8, 2003
version         : $Id: WorkloadApp.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __WORKLOAD_APP_H__
#define __WORKLOAD_APP_H__

#include <framework2/common.h>
#include <framework2/GApplication.h>
#include <framework2/Server.h>
#include "TraceEvent.h"
#include "SystemEvent.h"

    /**
     * An application driven by a trace workload (used in simulator only)
     */
    class WorkloadApp : public GApplication {
    private:

    void handleMod(TraceEvent *ev);
    void handleSub(TraceEvent *ev);
    void handleCreate(TraceEvent *ev);
    void handleDestroy(TraceEvent *ev);

    protected:

    /**
     * The server this app is running on
     */
    Server *server;

    /**
     * Interval between migration hueristics, (uint32)-1 if never
     */
    gtime_t migrateInterval;
    /**
     * Interval between interest updates, (uint32)-1 if never
     */
    gtime_t interestInterval;

    public:

    WorkloadApp(Server *server, gtime_t timerInterval, 
		gtime_t interestInterval);
    virtual ~WorkloadApp();

    void initWorld();
    void handleTraceEvent(TraceEvent *tev);
    void handleSystemEvent(SystemEvent *sev);
  };

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
