////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  WEvent.h

begin           : Oct 16, 2003
version         : $Id: WEvent.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __WEVENT_H__
#define __WEVENT_H__

#include <functional>
#include <framework2/common.h>

    /**
     * Superclass of Events in our event queue.
     */
    class WEvent {
    private:

    protected:

    public:

    typedef enum { TRACE_EVENT, SYSTEM_EVENT } eventclass_t;

    gtime_t time;  // time of event
    uint32  seqno; // unique sequence number to order simultaneous events
    eventclass_t cls;

    WEvent(gtime_t t, eventclass_t c);
    virtual ~WEvent();


    bool operator<(WEvent& other);
    bool operator>(WEvent& other);
    bool operator<=(WEvent& other);
    bool operator>=(WEvent& other);

  };

/**
 * Binary functional to compare two event pointers (sort by descending time)
 */
struct EventTimeComparator : public binary_function<WEvent *,WEvent *,bool> {

    /**
     * Returns true if b happens before a (reverse time, because prio_queue
     * orders from greatest to least)
     */
    bool operator()(WEvent *a, WEvent *b);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
