////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  WEvent.h

begin           : Oct 16, 2003
version         : $Id: WEvent.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include "WEvent.h"

    bool EventTimeComparator::operator()(WEvent *a, WEvent *b) {
    // if events occur at the same time, prefer system events
    // to go first (this is so migrations happen before actions
    // that take place immediately following migration)
    if (a->time == b->time) {
	if (a->cls == WEvent::SYSTEM_EVENT &&
	    b->cls == WEvent::TRACE_EVENT) {
	    return false;
	} else if (a->cls == WEvent::TRACE_EVENT &&
		   b->cls == WEvent::SYSTEM_EVENT) {
	    return true;
	}
    }

    return (*a) > (*b);
  }

///////////////////////////////////////////////////////////////////////////////

static uint32 uniq_seqno = 0;

WEvent::WEvent(gtime_t t, eventclass_t c) : time(t), cls(c) {
    seqno = uniq_seqno++;
}

WEvent::~WEvent() {
}

bool WEvent::operator<(WEvent& other) {
    if (time == other.time)
	return seqno < other.seqno;
    return time < other.time;
}
bool WEvent::operator>(WEvent& other) {
    if (time == other.time)
	return seqno > other.seqno;
    return time > other.time;
}
bool WEvent::operator<=(WEvent& other) {
    if (time == other.time)
	return seqno <= other.seqno;
    return time <= other.time;
}
bool WEvent::operator>=(WEvent& other) {
    if (time == other.time)
	return seqno >= other.seqno;
    return time >= other.time;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
